<?php

/*

    "Contact Form to Database" Copyright (C) 2011-2012 Michael Simpson  (email : michael.d.simpson@gmail.com)



    This file is part of Contact Form to Database.



    Contact Form to Database is free software: you can redistribute it and/or modify

    it under the terms of the GNU General Public License as published by

    the Free Software Foundation, either version 3 of the License, or

    (at your option) any later version.



    Contact Form to Database is distributed in the hope that it will be useful,

    but WITHOUT ANY WARRANTY; without even the implied warranty of

    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

    GNU General Public License for more details.



    You should have received a copy of the GNU General Public License

    along with Contact Form to Database.

    If not, see <http://www.gnu.org/licenses/>.

*/



require_once('ShortCodeLoader.php');



/**

 * Adapted from this excellent article:

 * http://scribu.net/wordpress/optimal-script-loading.html

 *

 * The idea is you have a shortcode that needs a script loaded, but you only

 * want to load it if the shortcode is actually called.

 */

abstract class ShortCodeScriptLoader extends ShortCodeLoader {



    var $doAddScript;



    public function register($shortcodeName) {

        $this->registerShortcodeToFunction($shortcodeName, 'handleShortcodeWrapper');



        // It will be too late to enqueue the script in the header,

        // so have to add it to the footer

        add_action('wp_footer', array($this, 'addScriptWrapper'));

    }



    public function handleShortcodeWrapper($atts, $content = null) {

        // Flag that we need to add the script

        $this->doAddScript = true;

        return $this->handleShortcode($atts, $content);

    }



    // Defined in super-class:

    //public abstract function handleShortcode($atts);



    public function addScriptWrapper() {

        // Only add the script if the shortcode was actually called

        if ($this->doAddScript) {

            $this->addScript();

        }

    }



    /**

     * @abstract override this function with calls to insert scripts needed by your shortcode in the footer

     * Example:

     *   wp_register_script('my-script', plugins_url('my-script.js', __FILE__), array('jquery'), '1.0', true);

     *   wp_print_scripts('my-script');

     * @return void

     */

    public abstract function addScript();



}

