<?php
/*
Plugin Name: Custom Post Type Export to CSV
Description: Export custom post type 'product' with static fields to CSV via a fixed URL.
Version: 1.0
Author: Custom
*/

if (!defined('ABSPATH')) {
    exit;
}

// Add rewrite rule for the custom URL
function add_custom_export_rewrite_rule() {
    add_rewrite_rule('^datafeed.csv$', 'index.php?custom_export=1', 'top');
}
add_action('init', 'add_custom_export_rewrite_rule');

function add_custom_query_vars($query_vars) {
    $query_vars[] = 'custom_export';
    return $query_vars;
}
add_filter('query_vars', 'add_custom_query_vars');

// Template redirect to handle the custom export
function handle_custom_export() {
    global $wp_query;

    if (isset($wp_query->query_vars['custom_export']) && $wp_query->query_vars['custom_export'] == '1') {
        custom_export_to_csv();
        exit;
    }
}
add_action('template_redirect', 'handle_custom_export');

// Function to create and serve the CSV
function custom_export_to_csv() {
    $args = array(
        'post_type' => 'product',
        'post_status' => 'publish',
        'posts_per_page' => -1,
		'orderby' => 'ID',
        'order' => 'ASC'     
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        $filename = 'datafeed.csv';
        $filepath = ABSPATH . $filename;

        $file = fopen($filepath, 'w');

        // Add CSV column headers
        $headers = array('id', 'title', 'description', 'availability', 'condition', 'price', 'link', 'image_link', 'brand', 'quantity_to_sell_on_facebook');
        fputcsv($file, $headers);
		
		$serial_number = 1;
	
        // Loop through posts and add data
        while ($query->have_posts()) {
            $query->the_post();
			
			$product_id = get_the_ID();
			$product_title = get_the_title();
        	$product_title = str_replace(
                array('&#8217;', '&#8242;', '’', '′'),
                array("'", "'", "'", "'"),
                $product_title
            );
			$product_description =  get_the_excerpt();
            $product_description = str_replace(
			        array('’', '′'), 
                    array("'", "'"),
                    $product_description
            );
			
			$product_image = get_the_post_thumbnail_url($product_id, 'full');
            $product_price = get_post_meta($product_id, 'prices', true);
			$formatted_price = intval(str_replace(',', '', $product_price)) . ' USD';
			
            $row = array(
                $serial_number,
				html_entity_decode($product_title),  
                $product_description,
                'in stock',
                'new',
				esc_html($formatted_price),
				get_permalink(),
				esc_url($product_image),
				'viking Metal Garages',
				'1'
				
            );
            fputcsv($file, $row);
			$serial_number++;
        }

        fclose($file);

        // Reset post data
        wp_reset_postdata();

        // Trigger file download
        header('Content-Description: File Transfer');
        header('Content-Type: application/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename=' . $filename);
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($filepath));
        readfile($filepath);

        // Delete the file after download
        unlink($filepath);
        exit;
    }
}
