<?php $saved_benefits = get_option('vmg_benefits', array());

?>

<h2>Benefits (RTO page)</h2>
<form method="post" action="">
    <?php wp_nonce_field('vmg_save_settings_nonce'); ?>

    <table id="benefits-table" class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th>Sr no. </th>
                <th>Title</th>
                <th>Description</th>
                <th>Image</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php


            if (!empty($saved_benefits)) {
                foreach ($saved_benefits as $key => $benefit) {
            ?>
            <tr>
                <td class="sr-no"></td>
                <td><input type="text" name="benefits[<?php echo $key; ?>][title]"
                        value="<?php echo esc_attr($benefit['title']); ?>" /></td>
                <td><textarea
                        name="benefits[<?php echo $key; ?>][description]"><?php echo esc_textarea($benefit['description']); ?></textarea>
                </td>
                <td>
                    <div class="image-upload-wrapper">
                        <input type="text" class="benefit-image" name="benefits[<?php echo $key; ?>][image]"
                            value="<?php echo esc_attr($benefit['image']); ?>" />
                        <button class="button upload-image-button" type="button">Upload</button>
                    </div>
                </td>
                <td><button class="button remove-benefit" type="button">Remove</button></td>
            </tr>
            <?php
                }
            }
            ?>
        </tbody>


    </table>

    <button id="add-benefit_op" class="button button-primary" type="button">Add Benefit</button>
    <?php submit_button('Save', 'primary', 'vmg_save'); ?>
</form>