<?php $saved_colors = get_option('vmg_colors', array());
$saved_colors_avail = get_option('vmg_colors_availability', []);

?>

<h2>colors</h2>
<form method="post" action="">
    <?php wp_nonce_field('vmg_save_settings_nonce'); ?>

    <table id="colors-table" class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th>Sr no. </th>
                <th>Title</th>
                <th>Image</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody id="colors-body">
            <?php


            if (!empty($saved_colors)) {
                $j = 1;
                foreach ($saved_colors as $key => $color) {
            ?>
            <tr>
                <td class="sr-no"><?php echo $j; ?></td>
                <td><input type="text" name="colors[<?php echo $key; ?>][title]"
                        value="<?php echo esc_attr($color['title']); ?>" /></td>
                <td>
                    <div class="image-upload-wrapper">
                        <input type="text" class="benefit-image" name="colors[<?php echo $key; ?>][image]"
                            value="<?php echo esc_attr($color['image']); ?>" />
                        <button class="button upload-image-button" type="button">Upload</button>
                    </div>
                </td>
                <td><button class="button remove-color" type="button">Remove</button></td>
            </tr>
            <?php
                    $j++;
                }
            }
            ?>
        </tbody>


    </table>

    <button id="add-color_op" class="button button-primary" type="button">Add Color</button>


    <h3>Contact for availability in your area colors</h3>
    <table id="colors-table" class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th>Sr no. </th>
                <th>Title</th>
                <th>Image</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody id="colors-body1">
            <?php


            if (!empty($saved_colors_avail)) {
                $i = 1;
                foreach ($saved_colors_avail as $key => $color) {
            ?>
            <tr>
                <td class="sr-no"><?php echo $i; ?></td>
                <td><input type="text" name="avai_colors[<?php echo $key; ?>][title]"
                        value="<?php echo esc_attr($color['title']); ?>" /></td>
                <td>
                    <div class="image-upload-wrapper">
                        <input type="text" class="benefit-image" name="avai_colors[<?php echo $key; ?>][image]"
                            value="<?php echo esc_attr($color['image']); ?>" />
                        <button class="button upload-image-button" type="button">Upload</button>
                    </div>
                </td>
                <td><button class="button remove-color" type="button">Remove</button></td>
            </tr>
            <?php
                    $i++;
                }
            }
            ?>
        </tbody>


    </table>

    <button id="add-color_op1" class="button button-primary" type="button">Add Color</button>
    <?php submit_button('Save', 'primary', 'vmg_save'); ?>
</form>