<?php $partners = get_option('vmg_partners', []); ?>

<h2>Partners</h2>
<form method="post" action="">
    <?php wp_nonce_field('vmg_save_settings_nonce'); ?>
    <table class="wp-list-table widefat fixed striped" id="partners-table">
        <thead>
            <tr>
                <th width="5%">Sr No.</th>
                <th width="25%">Image</th>
                <th width="30%">Description</th>
                <th width="30%">Feature List</th>
                <th width="5%">Action</th>
            </tr>
        </thead>
        <tbody id="partners-body">
            <?php
            if (!empty($partners)) {
                foreach ($partners as $index => $partner) { ?>
            <tr>
                <td width="5%" class="sr-number"><?php echo ($index + 1); ?></td>
                <td width="20%">
                    <input type="text" class="partner-image" name="partners[<?php echo $index; ?>][image]"
                        value="<?php echo esc_attr($partner['image']); ?>" placeholder="Image URL">
                    <button class="button upload-pimage-button">Upload</button>
                </td>
                <td width="30%">
                    <?php wp_editor(wp_kses_post($partner['description']), "partners_{$index}_desc", ['textarea_name' => "partners[$index][description]", 'textarea_rows' => 5]); ?>
                </td>
                <td width="30%">
                    <?php wp_editor(wp_kses_post($partner['features']), "partners_{$index}_features", ['textarea_name' => "partners[$index][features]", 'textarea_rows' => 5]); ?>
                </td>
                <td width="5%"><button class="button remove-row">Remove</button></td>
            </tr>
            <?php }
            } ?>
        </tbody>
    </table>

    <p><button type="button" class="button button-primary" id="add-partner">+ Add Partner</button></p>
    <?php submit_button('Save', 'primary', 'vmg_save'); ?>
</form>