<?php $process = get_option('vmg_process', []); ?>

<h2>Process</h2>
<form method="post" action="">
    <?php wp_nonce_field('vmg_save_settings_nonce'); ?>
    <table class="wp-list-table widefat fixed striped" id="process-table">
        <thead>
            <tr>
                <th width="5%">Sr No.</th>
                <th width="15%">BgClass</th>
                <th width="15%">Image</th>
                <th width="30%">Title</th>
                <th width="30%">Description</th>
                <th width="5%">Action</th>
            </tr>
        </thead>
        <tbody id="process-body">
            <?php
            if (!empty($process)) {
                foreach ($process as $index => $steps) { ?>
            <tr>
                <td width="5%" class="sr-number"><?php echo ($index + 1); ?></td>
                <td width="15%">
                    <input type="text" name="process[<?php echo $index; ?>][bgclass]"
                        value="<?php echo esc_attr($steps['bgclass']); ?>">
                    <br />
                </td>
                <td width="15%">
                    <input type="text" class="partner-image" name="process[<?php echo $index; ?>][image]"
                        value="<?php echo esc_attr($steps['image']); ?>" placeholder="Image URL">
                    <button class="button upload-pimage-button">Upload</button>
                </td>
                <td width="30%">
                    <input type="text" name="process[<?php echo $index; ?>][title]"
                        value="<?php echo esc_attr($steps['title']); ?>" style="width:100%">
                </td>
                <td width="30%">
                    <?php wp_editor(wp_kses_post($steps['description']), "process_{$index}_description", ['textarea_name' => "process[$index][description]", 'textarea_rows' => 5]); ?>
                </td>
                <td width="5%"><button class="button remove-row">Remove</button></td>
            </tr>
            <?php }
            } ?>
        </tbody>
    </table>

    <p><button type="button" class="button button-primary" id="add-process">+ Add Process +</button></p>
    <?php submit_button('Save', 'primary', 'vmg_save'); ?>
</form>