<?php
function vmg_register_custom_options_page()
{
    // Main page
    add_menu_page(
        'Theme Settings',
        'Theme Settings',
        'manage_options',
        'vmg-theme-settings',
        'vmg_theme_settings_page',
        'dashicons-admin-generic',
        60
    );
}
add_action('admin_menu', 'vmg_register_custom_options_page');

function vmg_enqueue_admin_scripts($hook)
{
    wp_enqueue_media();
    wp_enqueue_editor();
    wp_enqueue_script('vmg-admin-js', get_template_directory_uri() . '/inc/endpoints-customizations/admin/assets/js/admin-scripts.js', array('jquery'), time(), true);
    wp_enqueue_style('vmg-admin-css', get_template_directory_uri() . '/inc/endpoints-customizations/admin/assets/css/admin-styles.css', '', time(), 'all');



    wp_enqueue_style('select2', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css');
    wp_enqueue_script('select2', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js', array('jquery'), null, true);
}
add_action('admin_enqueue_scripts', 'vmg_enqueue_admin_scripts');



function vmg_theme_settings_page()
{
    if (isset($_POST['vmg_save'])) {
        check_admin_referer('vmg_save_settings_nonce');



        if (isset($_POST['benefits'])) {
            $benefits = $_POST['benefits'] ?? array();
            update_option('vmg_benefits', $benefits);
        }
        if (isset($_POST['roof_styles'])) {
            $roof_styles = $_POST['roof_styles'] ?? array();
            update_option('vmg_roof_styles', $roof_styles);
        }

        if (isset($_POST['partners'])) {
            $partners = isset($_POST['partners']) ? wp_unslash($_POST['partners']) : [];
            update_option('vmg_partners', $partners);
        }

        if (isset($_POST['process'])) {
            $process = isset($_POST['process']) ? wp_unslash($_POST['process']) : [];
            update_option('vmg_process', $process);
        }

        if (isset($_POST['colors'])) {
            $colors = isset($_POST['colors']) ? $_POST['colors'] : [];
            update_option('vmg_colors', $colors);
            $avai_colors = isset($_POST['avai_colors']) ? $_POST['avai_colors'] : [];

            update_option('vmg_colors_availability', $avai_colors);
        }


        echo '<div class="notice notice-success is-dismissible"><p>Settings saved successfully!</p></div>';
    }
    $active_tab = isset($_GET['tab']) ? $_GET['tab'] : '';
?>

<div class="wrap">
    <h1>Global Content</h1>
    <nav class="nav-tab-wrapper">
        <a href="?page=vmg-theme-settings"
            class="nav-tab <?php echo $active_tab == '' ? 'nav-tab-active' : ''; ?>">Benefits(RTO)</a>
        <a href="?page=vmg-theme-settings&tab=rto-styles"
            class="nav-tab <?php echo $active_tab == 'rto-styles' ? 'nav-tab-active' : ''; ?>">Roof Styles</a>
        <a href="?page=vmg-theme-settings&tab=partners"
            class="nav-tab <?php echo $active_tab == 'partners' ? 'nav-tab-active' : ''; ?>">Partners</a>
        <a href="?page=vmg-theme-settings&tab=process"
            class="nav-tab <?php echo $active_tab == 'process' ? 'nav-tab-active' : ''; ?>">Process</a>
        <a href="?page=vmg-theme-settings&tab=color-options"
            class="nav-tab <?php echo $active_tab == 'color-options' ? 'nav-tab-active' : ''; ?>">Color Options</a>
    </nav>

    <div class="tab-content">
        <?php
            switch ($active_tab) {
                case 'rto-styles':
                    $file = get_template_directory() . '/inc/endpoints-customizations/admin/theme-settings/rto-styles-tab.php';
                    if (file_exists($file)) {
                        require_once $file;
                    }
                    break;
                case 'partners':
                    $file = get_template_directory() . '/inc/endpoints-customizations/admin/theme-settings/partners-tab.php';
                    if (file_exists($file)) {
                        require_once $file;
                    }
                    break;

                case 'process':
                    $file = get_template_directory() . '/inc/endpoints-customizations/admin/theme-settings/process-tab.php';
                    if (file_exists($file)) {
                        require_once $file;
                    }
                    break;

                case 'color-options':
                    $file = get_template_directory() . '/inc/endpoints-customizations/admin/theme-settings/color-options-tab.php';
                    if (file_exists($file)) {
                        require_once $file;
                    }
                    break;

                default:
                    $file = get_template_directory() . '/inc/endpoints-customizations/admin/theme-settings/benefits-tab.php';
                    if (file_exists($file)) {
                        require_once $file;
                    }
                    break;
            }
            ?>
    </div>

</div>
<?php
}