<?php
// Register Custom Post Type
add_action('init', 'cfe_register_cpt');
function cfe_register_cpt()
{
    $labels = [
        'name' => 'Contact Form Entries',
        'singular_name' => 'Contact Form Entry',
        'menu_name' => 'Contact Form Entries',
        'add_new' => 'Add New',
        'add_new_item' => 'Add New Entry',
        'edit_item' => 'Edit Entry',
        'new_item' => 'New Entry',
        'view_item' => 'View Entry',
        'search_items' => 'Search Entries',
        'not_found' => 'No entries found',
        'not_found_in_trash' => 'No entries found in Trash',
    ];

    $args = [
        'labels' => $labels,
        'public' => false, // not visible on front-end
        'show_ui' => true, // admin UI visible
        'show_in_menu' => true,
        'capability_type' => 'post',
        'hierarchical' => false,
        'menu_position' => 25,
        'supports' => ['title'],
        'has_archive' => false,
        'rewrite' => false,
        'show_in_rest' => false,
    ];

    register_post_type('contact_form_entries', $args);

    // Register Custom Taxonomy
    $tax_labels = [
        'name' => 'Form Categories',
        'singular_name' => 'Form Category',
        'search_items' => 'Search Categories',
        'all_items' => 'All Categories',
        'edit_item' => 'Edit Category',
        'update_item' => 'Update Category',
        'add_new_item' => 'Add New Category',
        'new_item_name' => 'New Category Name',
        'menu_name' => 'Form Categories',
    ];

    register_taxonomy('form_category', 'contact_form_entries', [
        'labels' => $tax_labels,
        'hierarchical' => true,
        'public' => false,
        'show_ui' => true,
        'show_admin_column' => true,
        'show_in_nav_menus' => false,
        'show_tagcloud' => false,
    ]);
}
add_action('add_meta_boxes', 'cfe_add_meta_boxes');
function cfe_add_meta_boxes()
{
    add_meta_box(
        'cfe_details',
        'Contact Form Details',
        'cfe_details_callback',
        'contact_form_entries',
        'normal',
        'high'
    );
}

function cfe_details_callback($post)
{
    $fields = [
        'name' => 'Name',
        'phone' => 'Phone Number',
        'email' => 'Email',
        'state' => 'State',
        'zipcode' => 'Zipcode',
        'comment' => 'Comment',
        'form_source' => 'Form Source',
        'ip_address' => 'Ip Address',
        'page_url' => 'Page Url',
    ];

    foreach ($fields as $key => $label) {
        $value = get_post_meta($post->ID, '_' . $key, true);
        echo "<p><label><strong>$label:</strong></label><br>";
        if ($key === 'comment') {
            echo "<textarea style='width:100%;' readonly>" . esc_textarea($value) . "</textarea>";
        } else {
            echo "<input type='text' style='width:100%;' readonly value='" . esc_attr($value) . "'>";
        }
        echo "</p>";
    }
}


add_filter('manage_contact_form_entries_posts_columns', 'cfe_set_columns');
function cfe_set_columns($columns)
{
    $columns = [
        'cb' => $columns['cb'],
        'name' => 'Name',
        'email' => 'Email',
        'phone' => 'Phone',
        'date' => $columns['date']
    ];
    return $columns;
}

add_action('manage_contact_form_entries_posts_custom_column', 'cfe_custom_column', 10, 2);
function cfe_custom_column($column, $post_id)
{
    switch ($column) {
        case 'name':
            echo esc_html(get_post_meta($post_id, '_name', true));
            break;
        case 'email':
            echo esc_html(get_post_meta($post_id, '_email', true));
            break;
        case 'phone':
            echo esc_html(get_post_meta($post_id, '_phone', true));
            break;
    }
}

// 1️⃣ Add taxonomy dropdown
add_action('restrict_manage_posts', 'cfe_filter_by_taxonomy');
function cfe_filter_by_taxonomy()
{
    global $typenow;
    if ($typenow != 'contact_form_entries') return;

    $taxonomy = 'form_category';
    $selected = isset($_GET[$taxonomy]) ? $_GET[$taxonomy] : '';
    $info_taxonomy = get_taxonomy($taxonomy);

    wp_dropdown_categories([
        'show_option_all' => __("Show All {$info_taxonomy->label}"),
        'taxonomy' => $taxonomy,
        'name' => $taxonomy,
        'orderby' => 'name',
        'selected' => $selected,
        'show_count' => true,
        'hide_empty' => false,
        'value_field' => 'slug', // <---- Use slug instead of ID
    ]);
}

// 2️⃣ Filter admin posts by taxonomy
add_filter('pre_get_posts', 'cfe_filter_posts_by_taxonomy', 9999);
function cfe_filter_posts_by_taxonomy($query)
{
    global $pagenow;
    $type = 'contact_form_entries';
    $taxonomy = 'form_category';

    if (
        $pagenow == 'edit.php'
        && $query->is_main_query()
        && $query->get('post_type') == $type
        && !empty($_GET[$taxonomy])
        && $_GET[$taxonomy] != '0'
    ) {

        $query->set('tax_query', [
            [
                'taxonomy' => $taxonomy,
                'field' => 'slug', // <--- Use slug to match dropdown
                'terms' => sanitize_text_field($_GET[$taxonomy]),
            ]
        ]);
    }
}

add_action('quick_edit_custom_box', 'cfe_quick_edit', 10, 2);
function cfe_quick_edit($column_name, $post_type)
{
    if ($post_type != 'contact_form_entries') return;
    // Prevent editing in quick edit
}

add_action('admin_notices', 'cfe_export_button');
function cfe_export_button()
{
    global $typenow;
    if ($typenow != 'contact_form_entries') return;
    $params = isset($_GET['form_category']) ? '&form_category='.$_GET['form_category'] : '';
    $m = isset($_GET['m']) ? '&m='.$_GET['m'] : '';
    $url = admin_url('admin-post.php?action=cfe_export_csv'.$params.$m);
    echo '<div class="notice notice-info export-csv-data"><a href="' . $url . '" class="button button-primary">Export CSV</a></div>';
}

add_action('admin_post_cfe_export_csv', 'cfe_export_csv');
function cfe_export_csv()
{
    if (!current_user_can('manage_options')) wp_die('Unauthorized');

    $args = [
        'post_type' => 'contact_form_entries',
        'posts_per_page' => -1,
        'post_status' => 'publish'
    ];

    $m = sanitize_text_field($_GET['m']);

    if ( isset($_GET['m']) && !empty($_GET['m']) ) {
        $m = sanitize_text_field($_GET['m']);

        // Extract year and month
        $year  = substr($m, 0, 4);
        $month = substr($m, 4, 2);

        $args['date_query'] = array(
                array(
                    'year'  => $year,
                    'month' => $month
                ),
            );
    }


    if (isset($_GET['form_category']) && !empty($_GET['form_category'])) {
        $args['tax_query'] = [
            [
                'taxonomy' => 'form_category',
                'field' => 'slug',
                'terms' => $_GET['form_category']
            ]
        ];
    }

    $posts = get_posts($args);

    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename="contact-form-entries.csv"');

    $output = fopen('php://output', 'w');
    fputcsv($output, ['Name', 'Phone', 'Email', 'State', 'Zipcode', 'Comment', 'Page url', 'Form source', 'Ip Address']);

    foreach ($posts as $post) {
        $row = [
            get_post_meta($post->ID, '_name', true),
            get_post_meta($post->ID, '_phone', true),
            get_post_meta($post->ID, '_email', true),
            get_post_meta($post->ID, '_state', true),
            get_post_meta($post->ID, '_zipcode', true),
            get_post_meta($post->ID, '_comment', true),
            get_post_meta($post->ID, '_page_url', true),
            get_post_meta($post->ID, '_form_source', true),
            get_post_meta($post->ID, '_ip_address', true),
        ];
        fputcsv($output, $row);
    }
    fclose($output);
    exit;
}