<?php
// Add meta boxes only for specific page slug
add_action('add_meta_boxes', function () {
    global $post;
    if (empty($post)) return;

    if ($post->post_name === 'metal-garage-financing') {

        add_meta_box('finance_banner_section', 'Finance Banner Section', 'finance_banner_section_callback', 'page', 'normal', 'high');
        add_meta_box('smart_financing_section', 'Smart Financing Section', 'smart_financing_section_callback', 'page', 'normal', 'high');
        add_meta_box('financing_process_section', 'Financing Process Section', 'financing_process_section_callback', 'page', 'normal', 'high');
        add_meta_box('partners_section', 'Partners Section', 'partners_section_callback', 'page', 'normal', 'high');
        add_meta_box('explore_top_building_section', 'Explore Top Building Section', 'explore_top_building_section_callback', 'page', 'normal', 'high');
        add_meta_box('why_financing_section', 'Why Financing Section', 'why_financing_section_callback', 'page', 'normal', 'high');
        add_meta_box('credit_score_section', 'Credit Score Section', 'credit_score_section_callback', 'page', 'normal', 'high');
    }
});


// ===================== FINANCE BANNER SECTION =====================
function finance_banner_section_callback($post)
{
    $data = get_post_meta($post->ID, '_finance_banner', true) ?: [];
?>
<label>Title</label><br>
<input type="text" name="finance_banner[title]" value="<?= esc_attr($data['title'] ?? '') ?>"
    style="width:100%;"><br><br>

<label>Subtitle</label><br>
<input type="text" name="finance_banner[subtitle]" value="<?= esc_attr($data['subtitle'] ?? '') ?>"
    style="width:100%;"><br><br>

<label>Description</label><br>
<textarea name="finance_banner[description]"
    style="width:100%;height:100px;"><?= esc_textarea($data['description'] ?? '') ?></textarea><br><br>
<?php
}


// ===================== SMART FINANCING SECTION =====================
// ===========================
// Meta Box Callback Function
// ===========================
function smart_financing_section_callback($post)
{
    $data = get_post_meta($post->ID, '_smart_financing', true) ?: [];
    $options = $data['options'] ?? [];
?>
<label>Title</label><br>
<input type="text" name="smart_financing[title]" value="<?= esc_attr($data['title'] ?? '') ?>"
    style="width:100%;"><br><br>

<label>Subtitle</label><br>
<input type="text" name="smart_financing[subtitle]" value="<?= esc_attr($data['subtitle'] ?? '') ?>"
    style="width:100%;"><br><br>

<label>Description</label><br>
<textarea name="smart_financing[description]"
    style="width:100%;height:100px;"><?= esc_textarea($data['description'] ?? '') ?></textarea><br><br>

<h4>Options</h4>
<table id="finance-options-table" style="width:100%; border-collapse:collapse;" border="1">
    <thead>
        <tr>
            <th width="5%">Sr No.</th>
            <th width="30%">Title</th>
            <th width="30%">Description</th>
            <th width="30%">Image</th>
            <th width="5%">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php if (!empty($options)) : ?>
        <?php foreach ($options as $i => $opt) : ?>
        <tr>
            <td><?= $i + 1 ?></td>
            <td><input type="text" name="smart_financing[options][<?= $i ?>][title]"
                    value="<?= esc_attr($opt['title'] ?? '') ?>" style="width:100%;"></td>
            <td><textarea name="smart_financing[options][<?= $i ?>][description]"
                    style="width:100%;height:80px;"><?= esc_textarea($opt['description'] ?? '') ?></textarea></td>
            <td>
                <input type="text" name="smart_financing[options][<?= $i ?>][image]" id="finance_image_<?= $i ?>"
                    value="<?= esc_attr($opt['image'] ?? '') ?>">
                <button class="button upload-finance-image" data-target="finance_image_<?= $i ?>">Upload Image</button>
            </td>
            <td><button class="button remove-row">Remove</button></td>
        </tr>
        <?php endforeach; ?>
        <?php endif; ?>
    </tbody>
</table>
<br>
<button class="button" id="add-finance-row">+ Add Row</button>

<script>
jQuery(document).ready(function($) {
    // Add new repeater row
    $('#add-finance-row').on('click', function(e) {
        e.preventDefault();
        var rowCount = $('#finance-options-table tbody tr').length;
        var newRow = `<tr>
                    <td>${rowCount + 1}</td>
                    <td><input type="text" name="smart_financing[options][${rowCount}][title]" style="width:100%;"></td>
                    <td><textarea name="smart_financing[options][${rowCount}][description]" style="width:100%;height:80px;"></textarea></td>
                    <td>
                        <input type="text" name="smart_financing[options][${rowCount}][image]" id="finance_image_${rowCount}">
                        <button class="button upload-finance-image" data-target="finance_image_${rowCount}">Upload Image</button>
                    </td>
                    <td><button class="button remove-row">Remove</button></td>
                </tr>`;
        $('#finance-options-table tbody').append(newRow);
    });

    // Remove row
    $(document).on('click', '.remove-row', function(e) {
        e.preventDefault();
        $(this).closest('tr').remove();
    });

    // Upload Image
    $(document).on('click', '.upload-finance-image', function(e) {
        e.preventDefault();
        var target = $(this).data('target');
        var customUploader = wp.media({
            title: 'Select Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        }).on('select', function() {
            var attachment = customUploader.state().get('selection').first().toJSON();
            $('#' + target).val(attachment.url);
        }).open();
    });
});
</script>
<?php
}


// ===================== FINANCING PROCESS SECTION =====================
function financing_process_section_callback($post)
{
    $data = get_post_meta($post->ID, '_financing_process', true) ?: [];

    $steps = $data['steps'] ?? [];
?>
<label>Title</label><br>
<input type="text" name="financing_process[title]" value="<?= esc_attr($data['title'] ?? '') ?>"
    style="width:100%;"><br><br>

<label>Description</label><br>
<textarea name="financing_process[description]"
    style="width:100%;height:100px;"><?= esc_textarea($data['description'] ?? '') ?></textarea><br><br>

<h4>Process Steps</h4>
<table id="finance-process-table" style="width:100%; border-collapse:collapse;" border="1">
    <thead>
        <tr>
            <th>Sr No.</th>
            <th>Title</th>
            <th>Description</th>
        </tr>
    </thead>
    <tbody>
        <?php for ($i = 0; $i < 3; $i++): ?>
        <tr>
            <td><?= $i + 1 ?></td>
            <td><input type="text" name="financing_process[steps][<?= $i ?>][title]"
                    value="<?= esc_attr($steps[$i]['title'] ?? '') ?>" style="width:100%;"></td>
            <td><textarea name="financing_process[steps][<?= $i ?>][description]"
                    style="width:100%;height:80px;"><?= esc_textarea($steps[$i]['description'] ?? '') ?></textarea></td>
        </tr>
        <?php endfor; ?>
    </tbody>
</table>
<?php
}


// ===================== PARTNERS SECTION =====================
function partners_section_callback($post)
{
    $data = get_post_meta($post->ID, '_partners', true) ?: [];

?>

<label>Title</label><br>
<input type="text" name="partners[title]" value="<?= esc_attr($data['title'] ?? '') ?>" style="width:100%;">
<br>
<label>Description</label><br>
<?php

    wp_editor($data['subtitle'] ?? '', 'partners_subtitle', ['textarea_name' => 'partners[subtitle]', 'textarea_rows' => 5]);
}


// ===================== EXPLORE TOP BUILDING SECTION =====================
function explore_top_building_section_callback($post)
{
    $data = get_post_meta($post->ID, '_explore_top_building', true) ?: [];
?>
<label>Title</label><br>
<input type="text" name="explore_top_building[title]" value="<?= esc_attr($data['title'] ?? '') ?>"
    style="width:100%;"><br><br>
<label>Subtitle</label><br>
<?php wp_editor($data['subtitle'] ?? '', 'explore_top_building_subtitle', ['textarea_name' => 'explore_top_building[subtitle]', 'textarea_rows' => 5]); ?>
<?php
}


// ===================== WHY FINANCING SECTION =====================
function why_financing_section_callback($post)
{
    $data = get_post_meta($post->ID, '_why_financing', true) ?: [];
?>
<label>Title</label><br>
<input type="text" name="why_financing[title]" value="<?= esc_attr($data['title'] ?? '') ?>"
    style="width:100%;"><br><br>
<label>Subtitle</label><br>
<?php wp_editor($data['subtitle'] ?? '', 'why_financing_subtitle', ['textarea_name' => 'why_financing[subtitle]', 'textarea_rows' => 5]); ?>
<?php
}


// ===================== CREDIT SCORE SECTION =====================
function credit_score_section_callback($post)
{
    $data = get_post_meta($post->ID, '_credit_score', true) ?: [];
?>
<label>Title</label><br>
<input type="text" name="credit_score[title]" value="<?= esc_attr($data['title'] ?? '') ?>" style="width:100%;"><br><br>
<label>Subtitle</label><br>
<?php wp_editor($data['subtitle'] ?? '', 'credit_score_subtitle', ['textarea_name' => 'credit_score[subtitle]', 'textarea_rows' => 5]); ?>
<br>
<label>Button Text</label><br>
<input type="text" name="credit_score[button_text]" value="<?= esc_attr($data['button_text'] ?? '') ?>"
    style="width:100%;"><br><br>
<label>Button Link</label><br>
<input type="text" name="credit_score[button_link]" value="<?= esc_attr($data['button_link'] ?? '') ?>"
    style="width:100%;">
<?php
}


// ===================== SAVE META BOXES =====================
add_action('save_post', function ($post_id) {
    if (get_post_field('post_name', $post_id) !== 'metal-garage-financing') return;

    $fields = [
        'finance_banner',
        'smart_financing',
        'financing_process',
        'partners',
        'explore_top_building',
        'why_financing',
        'credit_score'
    ];

    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            update_post_meta($post_id, "_{$field}", $_POST[$field]);
        }
    }
});