<?php




add_action('add_meta_boxes', 'vmg_homepage_add_custom_metaboxes');
function vmg_homepage_add_custom_metaboxes()
{
    $front_page_id = get_option('page_on_front');
    $front_page = isset($_GET['post']) && $front_page_id === $_GET['post'] ? true : false;

    // Only add meta box if homepage exists
    if ($front_page) {
        add_meta_box('vmg_page_info', 'Page Info', 'vmg_page_info_callback', 'page', 'normal', 'default');
        add_meta_box('vmg_homepage_our_team', 'Our Team Section', 'vmg_homepage_our_team_callback', 'page', 'normal', 'default');
        add_meta_box('vmg_homepage_how_we_work', 'How We Work Section', 'vmg_homepage_how_we_work_callback', 'page', 'normal', 'default');
        add_meta_box('vmg_homepage_manufacturer', 'Manufacturer Section', 'vmg_homepage_manufacturer_callback', 'page', 'normal', 'default');
        add_meta_box('vmg_homepage_top_selling', 'Top Selling Section', 'vmg_homepage_top_selling_callback', 'page', 'normal', 'default');
        add_meta_box('vmg_homepage_other_metal', 'Other Metal Building Section', 'vmg_homepage_other_metal_callback', 'page', 'normal', 'default');
        add_meta_box('vmg_homepage_why_metal', 'Why Metal Garage Section', 'vmg_homepage_why_metal_callback', 'page', 'normal', 'default');
        add_meta_box('vmg_homepage_we_dont_let', 'We Don’t Let Section', 'vmg_homepage_we_dont_let_callback', 'page', 'normal', 'default');
        add_meta_box('vmg_homepage_finance', 'Finance Section', 'vmg_homepage_finance_callback', 'page', 'normal', 'default');
        add_meta_box('vmg_homepage_rto', 'RTO Section', 'vmg_homepage_rto_callback', 'page', 'normal', 'default');
        add_meta_box('vmg_homepage_expert_tips', 'Expert Tips Section', 'vmg_homepage_expert_tips_callback', 'page', 'normal', 'default');
    }
}


// Callback function
function vmg_page_info_callback($post)
{
    $data = get_post_meta($post->ID, '_vmg_page_info', true);

    $title       = $data['title'] ?? '';
    $subtitle    = $data['subtitle'] ?? '';
    $description = $data['description'] ?? '';
    $button_text = $data['button_text'] ?? '';

    // Title
    echo '<p><label><strong>Title:</strong></label><br />';
    echo '<input type="text" name="vmg_page_title" value="' . esc_attr($title) . '" style="width:100%" /></p>';

    // Subtitle
    echo '<p><label><strong>Subtitle:</strong></label><br />';
    echo '<input type="text" name="vmg_page_subtitle" value="' . esc_attr($subtitle) . '" style="width:100%" /></p>';

    // Description as WP Editor
    $settings = [
        'textarea_name' => 'vmg_page_description',
        'media_buttons' => true,
        'textarea_rows' => 6,
        'teeny'         => false,
    ];
    wp_editor($description, 'vmg_page_description', $settings);

    // Button Text
    echo '<p><label><strong>Button Text:</strong></label><br />';
    echo '<input type="text" name="vmg_page_button_text" value="' . esc_attr($button_text) . '" style="width:100%" /></p>';
}

// Save Meta Box
add_action('save_post', function ($post_id) {
    if (!current_user_can('edit_post', $post_id)) return;

    $data = [];

    if (isset($_POST['vmg_page_title'])) {
        $data['title'] = sanitize_text_field($_POST['vmg_page_title']);
    }
    if (isset($_POST['vmg_page_subtitle'])) {
        $data['subtitle'] = sanitize_text_field($_POST['vmg_page_subtitle']);
    }
    if (isset($_POST['vmg_page_description'])) {
        // Remove slashes and allow HTML
        $data['description'] = wp_kses_post(stripslashes($_POST['vmg_page_description']));
    }
    if (isset($_POST['vmg_page_button_text'])) {
        $data['button_text'] = sanitize_text_field($_POST['vmg_page_button_text']);
    }

    update_post_meta($post_id, '_vmg_page_info', $data);
});
/**
 * Utility input generators
 */
function vmg_text($name, $label, $value)
{
    echo "<p><label><strong>{$label}</strong></label><br><input type='text' name='{$name}' value='" . esc_attr($value) . "' style='width:100%;'></p>";
}
function vmg_textarea($name, $label, $value)
{
    echo "<p><label><strong>{$label}</strong></label><br><textarea name='{$name}' rows='3' style='width:100%;'>" . esc_textarea($value) . "</textarea></p>";
}

/**
 * ========== OUR TEAM ==========
 */
function vmg_homepage_our_team_callback($post)
{
    if ($post->ID != get_option('page_on_front')) return;

    $data = get_post_meta($post->ID, '_vmg_homepage_our_team', true);

    $title       = $data['title'] ?? '';
    $desc        = $data['desc'] ?? '';
    $link_text   = $data['link_text'] ?? '';
    $link_url    = $data['link_url'] ?? '';
    $icon        = $data['icon'] ?? '';

    vmg_text('vmg_team_title', 'Title', $title);
    vmg_textarea('vmg_team_desc', 'Description', $desc);
    vmg_text('vmg_team_link_text', 'Link Text', $link_text);
    vmg_text('vmg_team_link_url', 'Link URL', $link_url);

    // Icon upload
    echo '<p><label><strong>Icon:</strong></label><br />';
    echo '<input type="text" name="vmg_team_icon" class="vmg-upload-field" value="' . esc_attr($icon) . '" style="width:80%;" />';
    echo ' <button class="button vmg-upload-btn-1">Upload</button></p>';

?>
<script>
jQuery(document).ready(function($) {
    $(document).on('click', '.vmg-upload-btn-1', function(e) {
        e.preventDefault();
        const button = $(this);
        const field = button.siblings('.vmg-upload-field');
        const frame = wp.media({
            title: 'Select or Upload Icon',
            button: {
                text: 'Use this icon'
            },
            multiple: false
        });
        frame.on('select', function() {
            const attachment = frame.state().get('selection').first().toJSON();
            field.val(attachment.url);
        });
        frame.open();
    });
});
</script>
<?php
}

add_action('save_post', function ($post_id) {
    if (!current_user_can('edit_post', $post_id)) return;
    $data = [];
    foreach (['title', 'desc', 'link_text', 'link_url', 'icon'] as $f)
        if (isset($_POST["vmg_team_{$f}"])) $data[$f] = sanitize_text_field($_POST["vmg_team_{$f}"]);
    update_post_meta($post_id, '_vmg_homepage_our_team', $data);
});

/**
 * ========== HOW WE WORK ==========
 */
function vmg_homepage_how_we_work_callback($post)
{
    if ($post->ID != get_option('page_on_front')) return;

    $data = get_post_meta($post->ID, '_vmg_homepage_how_we_work', true);

    $title       = $data['title'] ?? '';
    $desc        = $data['desc'] ?? '';
    $link_text   = $data['link_text'] ?? '';
    $link_url    = $data['link_url'] ?? '';
    $icon        = $data['icon'] ?? '';

    vmg_text('vmg_hww_title', 'Title', $title);
    vmg_textarea('vmg_hww_desc', 'Description', $desc);
    vmg_text('vmg_hww_link_text', 'Link Text', $link_text);
    vmg_text('vmg_hww_link_url', 'Link URL', $link_url);

    // Icon upload
    echo '<p><label><strong>Icon:</strong></label><br />';
    echo '<input type="text" name="vmg_hww_icon" class="vmg-upload-field" value="' . esc_attr($icon) . '" style="width:80%;" />';
    echo ' <button class="button vmg-upload-btn">Upload</button></p>';

?>
<script>
jQuery(document).ready(function($) {
    $(document).on('click', '.vmg-upload-btn', function(e) {
        e.preventDefault();
        const button = $(this);
        const field = button.siblings('.vmg-upload-field');
        const frame = wp.media({
            title: 'Select or Upload Icon',
            button: {
                text: 'Use this icon'
            },
            multiple: false
        });
        frame.on('select', function() {
            const attachment = frame.state().get('selection').first().toJSON();
            field.val(attachment.url);
        });
        frame.open();
    });
});
</script>
<?php
}

add_action('save_post', function ($post_id) {
    if (!current_user_can('edit_post', $post_id)) return;
    $data = [];
    foreach (['title', 'desc', 'link_text', 'link_url', 'icon'] as $f)
        if (isset($_POST["vmg_hww_{$f}"])) $data[$f] = sanitize_text_field($_POST["vmg_hww_{$f}"]);
    update_post_meta($post_id, '_vmg_homepage_how_we_work', $data);
});

/**
 * ========== MANUFACTURER ==========
 */
function vmg_homepage_manufacturer_callback($post)
{
    if ($post->ID != get_option('page_on_front')) return;
    $data = get_post_meta($post->ID, '_vmg_homepage_manufacturer', true);
    vmg_textarea('vmg_manu_desc', 'Description', $data['desc'] ?? '');

    // $selected = $data['manufacturers'] ?? [];
    // $posts = get_posts(['post_type' => 'manufacturer', 'numberposts' => -1]);
    // echo '<p><strong>Select Manufacturers</strong><br><select name="vmg_manu_manufacturers[]" multiple="multiple" class="vmg-select2" style="width:100%;">';
    // foreach ($posts as $p) {
    //     $sel = in_array($p->ID, $selected) ? 'selected' : '';
    //     echo "<option value='{$p->ID}' {$sel}>{$p->post_title}</option>";
    // }
    // echo '</select></p>';
}
add_action('save_post', function ($post_id) {
    if (!current_user_can('edit_post', $post_id)) return;
    $data = [
        'desc' => sanitize_textarea_field($_POST['vmg_manu_desc'] ?? ''),
        'manufacturers' => isset($_POST['vmg_manu_manufacturers']) ? array_map('intval', $_POST['vmg_manu_manufacturers']) : []
    ];
    update_post_meta($post_id, '_vmg_homepage_manufacturer', $data);
});

/**
 * ========== TOP SELLING ==========
 */
function vmg_homepage_top_selling_callback($post)
{
    if ($post->ID != get_option('page_on_front')) return;

    $data = get_post_meta($post->ID, '_vmg_homepage_top_selling', true);

    // Title & Description (text & textarea)
    vmg_text('vmg_top_title', 'Title', $data['title'] ?? '');
    vmg_textarea('vmg_top_desc', 'Description', $data['desc'] ?? '');
    vmg_text('vmg_top_about_title', 'About Title', $data['about_title'] ?? '');

    // About Description as WP Editor
    $settings = [
        'textarea_name' => 'vmg_top_about_desc',
        'media_buttons' => true,
        'textarea_rows' => 8,
        'teeny'         => false,
    ];
    wp_editor($data['about_desc'] ?? '', 'vmg_top_about_desc', $settings);
}
add_action('save_post', function ($post_id) {
    if (!current_user_can('edit_post', $post_id)) return;

    $data = [];
    foreach (['title', 'desc', 'about_title'] as $f) {
        if (isset($_POST["vmg_top_{$f}"])) {
            $data[$f] = $_POST["vmg_top_{$f}"];

        }
    }

    // About Description: remove slashes before saving
    if (isset($_POST['vmg_top_about_desc'])) {
        $content = wp_kses_post(stripslashes($_POST['vmg_top_about_desc']));
        $data['about_desc'] = $content;
    }

    update_post_meta($post_id, '_vmg_homepage_top_selling', $data);
});



/**
 * ========== OTHER METAL BUILDING ==========
 */
function vmg_homepage_other_metal_callback($post)
{
    if ($post->ID != get_option('page_on_front')) return;

    $default_items = [
        [
            'image' => site_url() . '/wp-content/uploads/2025/10/Carports.webp',
            'title' => 'Metal Carports',
            'desc' => 'One of the most affordable ways to protect your car, prolong its lifespan, and get some storage space is to install a single-car garage.',
            'link' => '#',
        ],
        [
            'image' => site_url() . '/wp-content/uploads/2025/10/Utility-Buildings_.webp',
            'title' => 'Utility Buildings',
            'desc' => 'One of the most affordable ways to protect your car, prolong its lifespan, and get some storage space is to install a single-car garage.',
            'link' => '#',
        ],
        [
            'image' => site_url() . '/wp-content/uploads/2025/10/RV-Covers.webp',
            'title' => 'RV Covers',
            'desc' => 'One of the most affordable ways to protect your car, prolong its lifespan, and get some storage space is to install a single-car garage.',
            'link' => '#',
        ],
        [
            'image' => site_url() . '/wp-content/uploads/2025/10/Commercial-Buildings_.webp',
            'title' => 'Commercial Buildings',
            'desc' => 'One of the most affordable ways to protect your car, prolong its lifespan, and get some storage space is to install a single-car garage.',
            'link' => '#',
        ],
        [
            'image' => site_url() . '/wp-content/uploads/2025/10/Clear-Span-Buildings_.webp',
            'title' => 'Clear Span Buildings',
            'desc' => 'One of the most affordable ways to protect your car, prolong its lifespan, and get some storage space is to install a single-car garage.',
            'link' => '#',
        ],
        [
            'image' => site_url() . '/wp-content/uploads/2025/10/Metal-Barns.webp',
            'title' => 'Metal Barns',
            'desc' => 'One of the most affordable ways to protect your car, prolong its lifespan, and get some storage space is to install a single-car garage.',
            'link' => '#',
        ]
    ];

    $data = get_post_meta($post->ID, '_vmg_homepage_other_metal', true);

    // Merge default data if empty
    $items = !empty($data['categories']) ? $data['categories'] : $default_items;
    $title = $data['title'] ?? 'Other Metal Buildings';
    $desc = $data['desc'] ?? 'Explore our versatile range of metal structures, perfect for any need.';


    vmg_text('vmg_other_title', 'Title', $title);

    echo '<p><strong>Description</strong></p>';
    wp_editor($desc ?? '', 'vmg_other_desc', [
        'textarea_name' => 'vmg_other_desc',
        'media_buttons' => false,
        'textarea_rows' => 6
    ]);
    // vmg_textarea('', 'Description', );

    echo '<h4>Category Blocks</h4>';
    echo '<table class="widefat vmg-repeater-table">
            <thead>
                <tr><th>Sr No.</th><th>Title</th><th>Description</th><th>Link</th><th>Image</th><th>Action</th></tr>
            </thead>
            <tbody class="vmg-repeater-body">';

    foreach ($items as $index => $item) {
        echo '<tr>
            <td>' . ($index + 1) . '</td>
            <td><input type="text" name="vmg_other_cat[' . $index . '][title]" value="' . esc_attr($item['title']) . '" /></td>
            <td><textarea name="vmg_other_cat[' . $index . '][desc]" rows="3" style="width:100%">' . (!empty($item['desc']) ? html_entity_decode($item['desc']) : "") . '</textarea></td>
            <td><input type="text" name="vmg_other_cat[' . $index . '][link]" value="' . esc_attr($item['link']) . '" /></td>
            <td><input type="text" name="vmg_other_cat[' . $index . '][image]" class="vmg-upload-field" value="' . esc_attr($item['image']) . '" />
                <button class="button vmg-upload-btn">Upload</button></td>
            <td><button type="button" class="button vmg-remove-row">Remove</button></td>
        </tr>';
    }

    echo '</tbody></table>';
    echo '<p><button type="button" class="button button-primary vmg-add-row">+ Add Category</button></p>';

    // Template row
    echo '<script type="text/html" id="tmpl-vmg-other-metal-row">

    </script>';

?>
<script>
jQuery(document).ready(function($) {
    let index = jQuery('.vmg-repeater-body').children('tr').length;

    // Add row
    $('.vmg-add-row').click(function(e) {
        e.preventDefault();
        let tmpl = wp.template('vmg-other-metal-row');
        $('.vmg-repeater-body').append(`<tr>
            <td>${index + 1}</td>
            <td><input type="text" name="vmg_other_cat[${index}][title]" /></td>
            <td><textarea name="vmg_other_cat[${index}][desc]" rows="3" style="width:100%"></textarea></td>
            <td><input type="text" name="vmg_other_cat[${index}][link]" /></td>
            <td><input type="text" name="vmg_other_cat[${index}][image]" class="vmg-upload-field" />
                <button class="button vmg-upload-btn">Upload</button></td>
            <td><button type="button" class="button vmg-remove-row">Remove</button></td>
        </tr>`);
        index++;
    });

    // Remove row
    $(document).on('click', '.vmg-remove-row', function(e) {
        e.preventDefault();
        $(this).closest('tr').remove();
        // Recalculate Sr No.
        $('.vmg-repeater-body tr').each(function(i) {
            $(this).find('td:first').text(i + 1);
        });
    });

    // Media uploader
    $(document).on('click', '.vmg-upload-btn', function(e) {
        e.preventDefault();
        const button = $(this);
        const field = button.siblings('.vmg-upload-field');
        const frame = wp.media({
            title: 'Select or Upload Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        });
        frame.on('select', function() {
            const attachment = frame.state().get('selection').first().toJSON();
            field.val(attachment.url);
        });
        frame.open();
    });
});
</script>
<?php
}

// Save repeater data
add_action('save_post', function ($post_id) {
    if (!current_user_can('edit_post', $post_id)) return;

    $data = [
        'title' => $_POST['vmg_other_title'] ?? '',
        'desc'  => sanitize_textarea_field($_POST['vmg_other_desc'] ?? ''),
        'categories' => []
    ];

    if (isset($_POST['vmg_other_cat']) && is_array($_POST['vmg_other_cat'])) {
        foreach ($_POST['vmg_other_cat'] as $item) {
            $data['categories'][] = [
                'title' => sanitize_text_field($item['title'] ?? ''),
                'desc'  => htmlspecialchars(wp_kses_post($item['desc'] ?? ''), ENT_QUOTES, 'UTF-8'),
                'link'  => esc_url_raw($item['link'] ?? ''),
                'image' => esc_url_raw($item['image'] ?? ''),
            ];
        }
    }

    update_post_meta($post_id, '_vmg_homepage_other_metal', $data);
});



/**
 * ========== WHY METAL GARAGE ==========
 */
function vmg_homepage_why_metal_callback($post)
{
    if ($post->ID != get_option('page_on_front')) return;

    $default_items = [
        [
            'image' => site_url() . '/wp-content/uploads/2025/10/about_badge.gif',
            'title' => 'Expert Advisory',
            'desc' => 'Proudly manufactured in the USA using high-quality steel for lasting performance.',
        ],
        [
            'image' => site_url() . '/wp-content/uploads/2025/10/about_steel.gif',
            'title' => '100% Steel',
            'desc' => 'Proudly manufactured in the USA using high-quality steel for lasting performance.',
        ],
        [
            'image' => site_url() . '/wp-content/uploads/2025/10/about_american_flag.gif',
            'title' => 'Made in America',
            'desc' => 'Proudly manufactured in the USA using high-quality steel for lasting performance.',
        ],
        [
            'image' => site_url() . '/wp-content/uploads/2025/10/about_money.gif',
            'title' => 'Value For Money',
            'desc' => 'Proudly manufactured in the USA using high-quality steel for lasting performance.',
        ]
    ];

    $data = get_post_meta($post->ID, '_vmg_homepage_why_metal', true);
    $items = !empty($data['items']) ? $data['items'] : $default_items;
    vmg_text('vmg_why_title', 'Title', $data['title'] ?? '');
    vmg_textarea('vmg_why_desc', 'Description', $data['desc'] ?? '');

    echo '<h4>Why Blocks</h4>';
    echo '<table class="widefat vmg-repeater-table">
            <thead>
                <tr><th>Sr No.</th><th>Title</th><th>Description</th><th>Image</th><th>Action</th></tr>
            </thead>
            <tbody class="vmg-repeater-body-wh">';

    foreach ($items as $index => $item) {
        echo '<tr>
            <td>' . ($index + 1) . '</td>
            <td><input type="text" name="vmg_why[' . $index . '][title]" value="' . esc_attr($item['title']) . '" /></td>
            <td><textarea name="vmg_why[' . $index . '][desc]" rows="3" style="width:100%">' . ($item['desc'] ? html_entity_decode($item['desc']) : '') . '</textarea></td>
            <td><input type="text" name="vmg_why[' . $index . '][image]" class="vmg-upload-field" value="' . esc_attr($item['image']) . '" />
                <button class="button vmg-upload-btn">Upload</button></td>
            <td><button type="button" class="button vmg-remove-row">Remove</button></td>
        </tr>';
    }

    echo '</tbody></table>';
    echo '<p><button type="button" class="button button-primary vmg-add-row-wh">+ Add </button></p>';

    // Template row
    echo '<script type="text/html" id="tmpl-vmg-why-row">

    </script>';

?>
<script>
jQuery(document).ready(function($) {
    let index = jQuery('.vmg-repeater-body-wh').children('tr').length;
    console.log(index)
    // Add row
    $('.vmg-add-row-wh').click(function(e) {
        e.preventDefault();
        let tmpl = wp.template('vmg-why-row');
        $('.vmg-repeater-body-wh').append(`<tr>
            <td>${index + 1}</td>
            <td><input type="text" name="vmg_why[${index}][title]" /></td>
            <td><textarea name="vmg_why[${index}][desc]" rows="3" style="width:100%"></textarea></td>
            <td><input type="text" name="vmg_why[${index}][image]" class="vmg-upload-field" />
                <button class="button vmg-upload-btn-wh">Upload</button></td>
            <td><button type="button" class="button vmg-remove-row-wh">Remove</button></td>
        </tr>`);
        index++;
    });

    // Remove row
    $(document).on('click', '.vmg-remove-row-wh', function(e) {
        e.preventDefault();
        $(this).closest('tr').remove();
        // Recalculate Sr No.
        $('.vmg-repeater-body-wh tr').each(function(i) {
            $(this).find('td:first').text(i + 1);
        });
    });

    // Media uploader
    $(document).on('click', '.vmg-upload-btn-wh', function(e) {
        e.preventDefault();
        const button = $(this);
        const field = button.siblings('.vmg-upload-field');
        const frame = wp.media({
            title: 'Select or Upload Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        });
        frame.on('select', function() {
            const attachment = frame.state().get('selection').first().toJSON();
            field.val(attachment.url);
        });
        frame.open();
    });
});
</script>
<?php
}
add_action('save_post', function ($post_id) {
    if (!current_user_can('edit_post', $post_id)) return;

    $data = [
        'title' => sanitize_text_field($_POST['vmg_why_title'] ?? ''),
        'desc'  => sanitize_textarea_field($_POST['vmg_why_desc'] ?? ''),
    ];
    if (isset($_POST['vmg_why']) && is_array($_POST['vmg_why'])) {
        foreach ($_POST['vmg_why'] as $item) {
            $data['items'][] = [
                'title' => sanitize_text_field($item['title'] ?? ''),
                'desc'  => str_replace("'", '&#39;', wp_kses_post($item['desc'] ?? '')),
                'image' => esc_url_raw($item['image'] ?? ''),
            ];
        }
    }
    update_post_meta($post_id, '_vmg_homepage_why_metal', $data);
});

/**
 * ========== WE DON’T LET ==========
 */
function vmg_homepage_we_dont_let_callback($post)
{
    if ($post->ID != get_option('page_on_front')) return;
    $data = get_post_meta($post->ID, '_vmg_homepage_we_dont_let', true);
    vmg_text('vmg_dont_title', 'Title', $data['title'] ?? '');
    vmg_textarea('vmg_dont_desc', 'Description', $data['desc'] ?? '');
}
add_action('save_post', function ($post_id) {
    if (!current_user_can('edit_post', $post_id)) return;
    $data = [
        'title' => $_POST['vmg_dont_title'] ?? '',
        'desc'  => sanitize_textarea_field($_POST['vmg_dont_desc'] ?? ''),
    ];
    update_post_meta($post_id, '_vmg_homepage_we_dont_let', $data);
});

/**
 * ========== FINANCE ==========
 */
function vmg_homepage_finance_callback($post)
{
    if ($post->ID != get_option('page_on_front')) return;
    $data = get_post_meta($post->ID, '_vmg_homepage_finance', true);
    vmg_text('vmg_fin_title', 'Finance Title', $data['title'] ?? '');
    vmg_textarea('vmg_fin_subtitle', 'Subtitle', $data['subtitle'] ?? '');
    echo '<p><strong>Finance Description</strong></p>';
    wp_editor($data['desc'] ?? '', 'vmg_fin_desc', [
        'textarea_name' => 'vmg_fin_desc',
        'media_buttons' => false,
        'textarea_rows' => 6
    ]);
    vmg_text('vmg_fin_btn_text', 'Button Text', $data['btn_text'] ?? '');
    vmg_text('vmg_fin_url', 'URL', $data['url'] ?? '');
}
add_action('save_post', function ($post_id) {
    if (!current_user_can('edit_post', $post_id)) return;
    $data = [
        'title' => sanitize_text_field($_POST['vmg_fin_title'] ?? ''),
        'subtitle' => sanitize_text_field($_POST['vmg_fin_subtitle'] ?? ''),
        'desc'  => str_replace("'", '&#39;', wp_kses_post($_POST['vmg_fin_desc'] ?? '')),
        'btn_text' => sanitize_text_field($_POST['vmg_fin_btn_text'] ?? ''),
        'url' => esc_url_raw($_POST['vmg_fin_url'] ?? '')
    ];
    update_post_meta($post_id, '_vmg_homepage_finance', $data);
});

/**
 * ========== RTO ==========
 */
function vmg_homepage_rto_callback($post)
{
    if ($post->ID != get_option('page_on_front')) return;
    $data = get_post_meta($post->ID, '_vmg_homepage_rto', true);
    vmg_text('vmg_rto_title', 'RTO Title', $data['title'] ?? '');
    vmg_textarea('vmg_rto_subtitle', 'Subtitle', $data['subtitle'] ?? '');
    echo '<p><strong>RTO Description</strong></p>';
    wp_editor($data['desc'] ?? '', 'vmg_rto_desc', [
        'textarea_name' => 'vmg_rto_desc',
        'media_buttons' => false,
        'textarea_rows' => 6
    ]);
    vmg_text('vmg_rto_btn_text', 'Button Text', $data['btn_text'] ?? '');
    vmg_text('vmg_rto_url', 'URL', $data['url'] ?? '');
}
add_action('save_post', function ($post_id) {
    if (!current_user_can('edit_post', $post_id)) return;
    $data = [
        'title' => sanitize_text_field($_POST['vmg_rto_title'] ?? ''),
        'subtitle' => sanitize_text_field($_POST['vmg_rto_subtitle'] ?? ''),
        'desc'  => str_replace("'", '&#39;', wp_kses_post($_POST['vmg_rto_desc'] ?? '')),
        'btn_text' => sanitize_text_field($_POST['vmg_rto_btn_text'] ?? ''),
        'url' => esc_url_raw($_POST['vmg_rto_url'] ?? '')
    ];
    update_post_meta($post_id, '_vmg_homepage_rto', $data);
});

/**
 * ========== EXPERT TIPS ==========
 */
function vmg_homepage_expert_tips_callback($post)
{
    if ($post->ID != get_option('page_on_front')) return;
    $data = get_post_meta($post->ID, '_vmg_homepage_expert_tips', true);
    vmg_text('vmg_tips_title', 'Title', $data['title'] ?? '');
    vmg_textarea('vmg_tips_desc', 'Description', $data['desc'] ?? '');
}
add_action('save_post', function ($post_id) {
    if (!current_user_can('edit_post', $post_id)) return;
    $data = [
        'title' => $_POST['vmg_tips_title'] ?? '',
        'desc'  => sanitize_textarea_field($_POST['vmg_tips_desc'] ?? ''),
    ];
    update_post_meta($post_id, '_vmg_homepage_expert_tips', $data);
});