<?php
// Hook to add meta boxes
add_action('add_meta_boxes', 'rto_add_custom_meta_boxes');

function rto_add_custom_meta_boxes()
{
    global $post;

    // Only show on specific page slug
    if ($post && $post->post_name === 'rent-to-own-metal-buildings') {

        // Banner Section
        add_meta_box(
            'rto_banner_section',
            'Banner Section',
            'rto_banner_section_callback',
            'page',
            'normal',
            'high'
        );

        // Calculate Section
        add_meta_box(
            'rto_calculate_section',
            'Calculate Section',
            'rto_calculate_section_callback',
            'page',
            'normal',
            'high'
        );

        // Metal Building
        add_meta_box(
            'rto_metal_building',
            'Metal Building Section',
            'rto_metal_building_callback',
            'page',
            'normal',
            'high'
        );

        // About RTO Section
        add_meta_box(
            'rto_about_section',
            'About RTO Section',
            'rto_about_section_callback',
            'page',
            'normal',
            'high'
        );

        // Benefits Section
        add_meta_box(
            'rto_benefits_section',
            'Benefits Section',
            'rto_benefits_section_callback',
            'page',
            'normal',
            'high'
        );

        // Credit Score Section
        add_meta_box(
            'rto_credit_section',
            'Credit Score Section',
            'rto_credit_section_callback',
            'page',
            'normal',
            'high'
        );

        // Process Section
        add_meta_box(
            'rto_process_section',
            'Process Section',
            'rto_process_section_callback',
            'page',
            'normal',
            'high'
        );

        // Prices Section
        add_meta_box(
            'rto_prices_section',
            'Prices Section',
            'rto_prices_section_callback',
            'page',
            'normal',
            'high'
        );

        // RTO vs Financing Section
        add_meta_box(
            'rto_vs_financing_section',
            'Rent To Own Vs. Financing Options Section',
            'rto_vs_financing_section_callback',
            'page',
            'normal',
            'high'
        );

        // Partners Section
        add_meta_box(
            'rto_partners_section',
            'Partners Section',
            'rto_partners_section_callback',
            'page',
            'normal',
            'high'
        );

        // FAQ Section
        add_meta_box(
            'rto_faq_section',
            'FAQ Section',
            'rto_faq_section_callback',
            'page',
            'normal',
            'high'
        );
    }
}

// Callback functions
function rto_banner_section_callback($post)
{
    wp_nonce_field('rto_banner_section_save', 'rto_banner_section_nonce');

    // Get saved values
    $page_title = get_post_meta($post->ID, '_rto_banner_page_title', true);
    $page_subtitle = get_post_meta($post->ID, '_rto_banner_page_subtitle', true);
    $description = get_post_meta($post->ID, '_rto_banner_description', true);
    $banner_bg_image = get_post_meta($post->ID, '_rto_banner_bg_image', true);


    $banner_images = get_post_meta($post->ID, '_rto_banner_images', true);
    $phone_number = get_post_meta($post->ID, '_rto_banner_phone', true);
?>

<style>
.btn-hide {
    display: none;
}
</style>

<p>
    <label>Page Title:</label><br />
    <input type="text" name="rto_banner_page_title" value="<?php echo esc_attr($page_title); ?>" style="width:100%;">
</p>

<p>
    <label>Page Subtitle:</label><br />
    <input type="text" name="rto_banner_page_subtitle" value="<?php echo esc_attr($page_subtitle); ?>"
        style="width:100%;">
</p>

<p>
    <label>Description:</label><br />
    <textarea name="rto_banner_description" style="width:100%;"><?php echo esc_textarea($description); ?></textarea>
</p>

<p>
    <label>Banner Images (2 images max):</label><br />
<div class="rto-banner-images-container">
    <?php
        if ($banner_images):
            $banner_images = !empty($banner_images) ? explode(',', $banner_images) : array();
            foreach ($banner_images as $img):
                if ($img):
        ?>
    <div class="image-wrap" style="display:inline-block; margin-right:10px;">
        <img src="<?php echo esc_url($img); ?>" style="max-width:200px; display:block; margin-bottom:5px;" />
        <button class="button rto-remove-bn-btn">Remove</button>
    </div>
    <?php
                endif;
            endforeach;
        endif;
        ?>
    <div class="banner-upload-wrap"
        <?php echo !empty($banner_images) && (count($banner_images) >= 2) ? 'style="display:none;"' : ''; ?>>
        <input type="hidden" name="rto_banner_images" id="rto_banner_images"
            value="<?php echo !empty($banner_images) ? esc_attr(implode(',', $banner_images)): ''; ?>" />
        <button class="button rto-upload-bn-btn">Upload</button>
    </div>
</div>
</p>
<p>
    <label>Phone Number:</label><br />
    <input type="text" name="rto_banner_phone" value="<?php echo esc_attr($phone_number); ?>" style="width:100%;">
</p>

<script>
jQuery(document).ready(function($) {
    // Upload button
    $(document).on('click', '.rto-upload-bg-btn', function(e) {
        e.preventDefault();
        var container = $(this).closest('.rto-banner-bg-container');
        var inputField = container.find('input[type="text"]');

        var custom_uploader = wp.media({
            title: 'Select Banner Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        }).on('select', function() {
            var attachment = custom_uploader.state().get('selection').first().toJSON();
            inputField.val(attachment.url).hide();
            // Show preview and remove button
            container.append('<img src="' + attachment.url +
                '" style="max-width:200px; display:block; margin-bottom:5px;" /><button class="button rto-remove-bg-btn">Remove</button>'
            );
            jQuery('.banner-image-up').addClass('btn-hide');
        }).open();
    });

    // Remove button
    $(document).on('click', '.rto-remove-bg-btn', function(e) {
        e.preventDefault();
        var container = $(this).closest('.rto-banner-bg-container');
        container.find('img').remove();
        container.find('input[type="text"]').val('').show();
        container.find('.rto-upload-bg-btn').show();
        $(this).remove();
        jQuery('.banner-image-up').removeClass('btn-hide');
    });
});

jQuery(document).ready(function($) {
    function updateBannerInput() {
        var urls = [];
        $('.rto-banner-images-container .image-wrap img').each(function() {
            urls.push($(this).attr('src'));
        });
        $('#rto_banner_images').val(urls.join(','));
        // Hide upload button if 2 images
        if (urls.length >= 2) {
            $('.banner-upload-wrap').hide();
        } else {
            $('.banner-upload-wrap').show();
        }
    }

    // Upload button
    $(document).on('click', '.rto-upload-bn-btn', function(e) {
        e.preventDefault();
        var container = $(this).closest('.rto-banner-images-container');
        var custom_uploader = wp.media({
            title: 'Select Banner Images',
            button: {
                text: 'Use this image'
            },
            multiple: false
        }).on('select', function() {
            var attachment = custom_uploader.state().get('selection').first().toJSON();
            container.find('.banner-upload-wrap').before(
                '<div class="image-wrap" style="display:inline-block; margin-right:10px;">' +
                '<img src="' + attachment.url +
                '" style="max-width:200px; display:block; margin-bottom:5px;" />' +
                '<button class="button rto-remove-bn-btn">Remove</button>' +
                '</div>'
            );
            updateBannerInput();
        }).open();
    });

    // Remove button
    $(document).on('click', '.rto-remove-bn-btn', function(e) {
        e.preventDefault();
        $(this).closest('.image-wrap').remove();
        updateBannerInput();
    });

    updateBannerInput(); // Initial update
});
</script>

<?php
}


function rto_calculate_section_callback($post)
{
    wp_nonce_field('rto_calculate_section_save', 'rto_calculate_section_nonce');

    $section_title = get_post_meta($post->ID, '_rto_calculate_section_title', true);
    $section_subtitle = get_post_meta($post->ID, '_rto_calculate_section_subtitle', true);
    // $calculate_cost_image = get_post_meta($post->ID, '_rto_calculate_cost_image', true);
?>

<p>
    <label>Section Title:</label><br />
    <input type="text" name="rto_calculate_section_title" value="<?php echo esc_attr($section_title); ?>"
        style="width:100%;">
</p>

<p>
    <label>Section Subtitle:</label><br />
    <textarea name="rto_calculate_section_subtitle"
        style="width:100%;"><?php echo esc_textarea($section_subtitle); ?></textarea>
</p>

<!-- <p>
    <label>Calculate Cost Image (1 image only):</label><br />
    <input type="text" name="rto_calculate_cost_image" id="rto_calculate_cost_image"
        value="<?php echo esc_attr($calculate_cost_image); ?>" style="width:80%;" />
    <button class="button rto-upload-btn3" data-target="rto_calculate_cost_image">Upload</button>
</p> -->

<!-- <script>
jQuery(document).ready(function($) {
    $('.rto-upload-btn3').click(function(e) {
        e.preventDefault();
        var button = $(this);
        var target = $('#' + button.data('target'));
        var custom_uploader = wp.media({
            title: 'Select Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        }).on('select', function() {
            var attachment = custom_uploader.state().get('selection').first().toJSON();
            target.val(attachment.url);
        }).open();
    });
});
</script> -->

<?php
}

function rto_metal_building_callback($post)
{
    wp_nonce_field('rto_metal_building_save', 'rto_metal_building_nonce');

    $section_title = get_post_meta($post->ID, '_rto_metal_building_title', true);
    $section_subtitle = get_post_meta($post->ID, '_rto_metal_building_subtitle', true);
    $building_price_limit = get_post_meta($post->ID, '_rto_metal_building_price_limit', true);
?>

<p>
    <label>Section Title:</label><br />
    <input type="text" name="rto_metal_building_title" value="<?php echo esc_attr($section_title); ?>"
        style="width:100%;">
</p>

<p>
    <label>Section Subtitle:</label><br />
    <textarea name="rto_metal_building_subtitle"
        style="width:100%;"><?php echo esc_textarea($section_subtitle); ?></textarea>
</p>

<p>
    <label>Building Price Limit:</label><br />
    <input type="number" name="rto_metal_building_price_limit" value="<?php echo esc_attr($building_price_limit); ?>"
        style="width:100%;">
    <br /><small>Only buildings under this price limit will show on the RTO page.</small>
</p>

<?php
}

function rto_about_section_callback($post)
{
    wp_nonce_field('rto_about_section_save', 'rto_about_section_nonce');

    $section_title = get_post_meta($post->ID, '_rto_about_section_title', true);
    $section_description = get_post_meta($post->ID, '_rto_about_section_description', true);
?>

<p>
    <label>Section Title:</label><br />
    <input type="text" name="rto_about_section_title" value="<?php echo esc_attr($section_title); ?>"
        style="width:100%;">
</p>

<p>
    <label>Section Description:</label><br />
    <?php
        wp_editor(
            $section_description,
            'rto_about_section_description',
            array(
                'textarea_name' => 'rto_about_section_description',
                'media_buttons' => true,
                'textarea_rows' => 10,
            )
        );
        ?>
</p>

<?php
}

function rto_benefits_section_callback($post)
{
    wp_nonce_field('rto_benefits_section_save', 'rto_benefits_section_nonce');

    $section_title = get_post_meta($post->ID, '_rto_benefits_section_title', true);
    $section_subtitle = get_post_meta($post->ID, '_rto_benefits_section_subtitle', true);
    $benefits_json = get_post_meta($post->ID, '_rto_benefits_list', true);
    $benefits = $benefits_json ? json_decode($benefits_json, true) : array();
    if (empty($benefits)) {
        $benefits = [
            [
                "title" => "No Credit Check",
                "description" => "For most of the post-paid purchases, you are required to have a positive credit score that ensures quick loan approval for you. However, the RTO program doesn’t require any credit score to own your favorite metal garage.",
                "image" => site_url() . "/wp-content/uploads/2025/10/No_Credit_Check.webp",
            ],
            [
                "title" => "Same Day Approval",
                "description" => "Like other loan and financing options you aren’t required to wait for a few days for loan approval. The RTO program by Viking Metal Garages offers same-day approval which makes it easy for you to order the Metal Garage on the same day.",
                "image" => site_url() . "/wp-content/uploads/2025/10/Same_Day_Approval.webp",
            ],
            [
                "title" => "More Than Just Storage",
                "description" => "All RTO buildings are not restricted to a single-use. Our metal structures can be used for parking, workshop, garage, she-sheds, man caves, and even for residential purposes.",
                "image" => site_url() . "/wp-content/uploads/2025/10/More_Than_Just_Storage.webp",
            ],
            [
                "title" => "Pay-off Anytime",
                "description" => "This is an amazing trait of Rent-To-Own Metal Garages. Initially, you can purchase a steel building with RTO option, but if you have ample money to payout for the building, you can pay out the amount to clear your dues and completely own your metal building structure.",
                "image" => site_url() . "/wp-content/uploads/2025/10/Pay_off_Anytime.webp",
            ],
            [
                "title" => "Small Down Payment",
                "description" => "At the time of order, you only need to pay a small amount of the complete payment. This gives you leverage in owning your steel structure with a small down payment.",
                "image" => site_url() . "/wp-content/uploads/2025/10/Small_Down_Payment.webp",
            ],
        ];
    }
?>

<p>
    <label>Section Title:</label><br />
    <input type="text" name="rto_benefits_section_title" value="<?php echo esc_attr($section_title); ?>"
        style="width:100%;">
</p>

<p>
    <label>Section Subtitle:</label><br />
    <textarea name="rto_benefits_section_subtitle"
        style="width:100%;"><?php echo esc_textarea($section_subtitle); ?></textarea>
</p>

<p>
    <label>Benefits:</label><br />
<table id="rto-benefits-table"
    style="width:100%; border-collapse: collapse; border:1px solid #ccc; max-height:600px; overflow-y:auto; display:block; overflow-x: hidden;">
    <thead style="display:table; width:100%; table-layout:fixed;">
        <tr>
            <th style="width:5%;">Sr No</th>
            <th style="width:25%;">Title</th>
            <th style="width:40%;">Description</th>
            <th style="width:20%;">Image</th>
            <th style="width:10%;">Action</th>
        </tr>
    </thead>
    <tbody id="rto-benefits-tbody" style="display:table; width:100%; table-layout:fixed;">
        <?php
            if ($benefits) {
                $count = 1;
                foreach ($benefits as $key => $benefit) {

            ?>
        <tr>
            <td style="width:5%;"><?php echo $count; ?></td>
            <td style="width:25%;"><input type="text" name="rto_benefits_list[<?php echo $key; ?>][title]"
                    class="benefit-title" value="<?php echo esc_attr($benefit['title']); ?>" style="width:100%"></td>
            <td style="width:40%;"><textarea class="benefit-desc"
                    name="rto_benefits_list[<?php echo $key; ?>][description]" rows="5"
                    style="width:100%"><?php echo esc_textarea($benefit['description']); ?></textarea></td>
            <td style="width:20%;">
                <input type="text" class="benefit-image" name="rto_benefits_list[<?php echo $key; ?>][image]"
                    value="<?php echo esc_attr($benefit['image']); ?>">
                <button class="button rto-upload-btn">Upload</button>
            </td>
            <td style="width:10%;"><button class="button rto-remove-btn">Remove</button></td>
        </tr>
        <?php
                    $count++;
                }
            }
            ?>
    </tbody>
</table>
<button class="button" id="rto-add-benefit">Add Benefit</button>
<input type="hidden" name="rto_benefits_list" id="rto_benefits_list" value='<?php echo esc_attr($benefits_json); ?>'>
</p>

<script>
jQuery(document).ready(function($) {
    function updateHiddenInput() {
        var benefits = [];
        $('#rto-benefits-tbody tr').each(function() {
            var title = $(this).find('.benefit-title').val();
            var desc = $(this).find('.benefit-desc').val();
            var image = $(this).find('.benefit-image').val();
            benefits.push({
                title: title,
                description: desc,
                image: image
            });
        });
        $('#rto_benefits_list').val(JSON.stringify(benefits));
        // update Sr No
        $('#rto-benefits-tbody tr').each(function(i) {
            $(this).find('td:first').text(i + 1);
        });
    }

    $('#rto-add-benefit').click(function(e) {
        const length = jQuery('#rto-benefits-tbody').children('tr').length;
        e.preventDefault();
        var newRow = '<tr>' +
            '<td style="width:5%;"></td>' +
            '<td style="width:25%;"><input type="text" name="rto_benefits_list[' + length +
            '][title]" class="benefit-title" style="width:100%"></td>' +
            '<td style="width:40%;"><textarea class="benefit-desc" rows="5" name="rto_benefits_list[' +
            length +
            '][description]" style="width:100%"></textarea></td>' +
            '<td style="width:20%;"><input type="text" name="rto_benefits_list[' + length +
            '][image]" class="benefit-image" ><button class="button rto-upload-btn">Upload</button></td>' +
            '<td style="width:10%;"><button class="button rto-remove-btn">Remove</button></td>' +
            '</tr>';
        $('#rto-benefits-tbody').append(newRow);
        updateHiddenInput();
    });

    $(document).on('click', '.rto-remove-btn', function(e) {
        e.preventDefault();
        $(this).closest('tr').remove();
        updateHiddenInput();
    });

    $(document).on('change keyup', '.benefit-title, .benefit-desc, .benefit-image', function() {
        updateHiddenInput();
    });

    // Media uploader
    $(document).on('click', '.rto-upload-btn', function(e) {
        e.preventDefault();
        var button = $(this);
        var target = button.siblings('.benefit-image');
        var custom_uploader = wp.media({
            title: 'Select Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        }).on('select', function() {
            var attachment = custom_uploader.state().get('selection').first().toJSON();
            target.val(attachment.url).trigger('change');
        }).open();
    });

    updateHiddenInput(); // initial update
});
</script>
<style>
#rto-benefits-table thead,
#rto-benefits-table tbody {
    display: block;
}

#rto-benefits-table tbody {
    max-height: 500px;
    overflow-y: auto;
}

#rto-benefits-table th,
#rto-benefits-table td {
    border: 1px solid #ccc;
    padding: 5px;
}
</style>
<?php
}


function rto_process_section_callback($post)
{
    wp_nonce_field('rto_process_section_save', 'rto_process_section_nonce');

    $section_title = get_post_meta($post->ID, '_rto_process_section_title', true);
    $section_subtitle = get_post_meta($post->ID, '_rto_process_section_subtitle', true);
?>

<p>
    <label>Section Title:</label><br />
    <input type="text" name="rto_process_section_title" value="<?php echo esc_attr($section_title); ?>"
        style="width:100%;">
</p>

<p>
    <label>Section Subtitle:</label><br />
    <textarea name="rto_process_section_subtitle"
        style="width:100%;"><?php echo esc_textarea($section_subtitle); ?></textarea>
</p>

<?php
}
function rto_credit_section_callback($post)
{
    wp_nonce_field('rto_credit_section_save', 'rto_credit_section_nonce');

    $section_title = get_post_meta($post->ID, '_rto_credit_section_title', true);
    $section_subtitle = get_post_meta($post->ID, '_rto_credit_section_subtitle', true);
    $phone_number = get_post_meta($post->ID, '_rto_credit_phone', true);
    $financing_btn_link = get_post_meta($post->ID, '_rto_credit_financing_link', true);
    // $bg_image = get_post_meta($post->ID, '_rto_credit_bg_image', true);
    $mobile_image = get_post_meta($post->ID, '_rto_credit_mobile_image', true);
?>

<p>
    <label>Section Title:</label><br />
    <input type="text" name="rto_credit_section_title" value="<?php echo esc_attr($section_title); ?>"
        style="width:100%;">
</p>

<p>
    <label>Section Subtitle:</label><br />
    <textarea name="rto_credit_section_subtitle"
        style="width:100%;"><?php echo esc_textarea($section_subtitle); ?></textarea>
</p>

<p>
    <label>Phone Number:</label><br />
    <input type="text" name="rto_credit_phone" value="<?php echo esc_attr($phone_number); ?>" style="width:100%;">
</p>

<p>
    <label>Financing Button Link:</label><br />
    <input type="text" name="rto_credit_financing_link" value="<?php echo esc_attr($financing_btn_link); ?>"
        style="width:100%;">
</p>

<!-- <p>
    <label>Background Image (1 image):</label><br />
    <input type="text" name="rto_credit_bg_image" id="rto_credit_bg_image" value="<?php echo esc_attr($bg_image); ?>"
        style="width:80%;" />
    <button class="button rto-upload-btn4" data-target="rto_credit_bg_image">Upload</button>
</p> -->

<p>
    <label>Section Image for Mobile (1 image):</label><br />
    <input type="text" name="rto_credit_mobile_image" id="rto_credit_mobile_image"
        value="<?php echo esc_attr($mobile_image); ?>" style="width:80%;" />
    <button class="button rto-upload-btn5" data-target="rto_credit_mobile_image">Upload</button>
</p>

<script>
jQuery(document).ready(function($) {
    $('.rto-upload-btn5').click(function(e) {
        e.preventDefault();
        var button = $(this);
        var target = $('#' + button.data('target'));
        var custom_uploader = wp.media({
            title: 'Select Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        }).on('select', function() {
            var attachment = custom_uploader.state().get('selection').first().toJSON();
            target.val(attachment.url);
        }).open();
    });
});
</script>

<?php
}



function rto_prices_section_callback($post)
{
    wp_nonce_field('rto_prices_section_save', 'rto_prices_section_nonce');

    $section_title = get_post_meta($post->ID, '_rto_prices_section_title', true);
    $section_description = get_post_meta($post->ID, '_rto_prices_section_description', true);
?>

<p>
    <label>Section Title:</label><br />
    <input type="text" name="rto_prices_section_title" value="<?php echo esc_attr($section_title); ?>"
        style="width:100%;">
</p>

<p>
    <label>Section Description:</label><br />
    <?php
        wp_editor(
            $section_description,
            'rto_prices_section_description',
            array(
                'textarea_name' => 'rto_prices_section_description',
                'media_buttons' => true,
                'textarea_rows' => 10,
            )
        );
        ?>
</p>

<?php
}

function rto_vs_financing_section_callback($post)
{
    wp_nonce_field('rto_vs_financing_section_save', 'rto_vs_financing_section_nonce');

    $section_title = get_post_meta($post->ID, '_rto_vs_financing_section_title', true);
    $section_description = get_post_meta($post->ID, '_rto_vs_financing_section_description', true);
?>

<p>
    <label>Section Title:</label><br />
    <input type="text" name="rto_vs_financing_section_title" value="<?php echo esc_attr($section_title); ?>"
        style="width:100%;">
</p>

<p>
    <label>Section Description:</label><br />
    <?php
        wp_editor(
            $section_description,
            'rto_vs_financing_section_description',
            array(
                'textarea_name' => 'rto_vs_financing_section_description',
                'media_buttons' => true,
                'textarea_rows' => 10,
            )
        );
        ?>
</p>

<?php
}

function rto_partners_section_callback($post)
{
    wp_nonce_field('rto_partners_section_save', 'rto_partners_section_nonce');

    $section_title = get_post_meta($post->ID, '_rto_partners_section_title', true);
    $section_subtitle = get_post_meta($post->ID, '_rto_partners_section_subtitle', true);
?>

<p>
    <label>Section Title:</label><br />
    <input type="text" name="rto_partners_section_title" value="<?php echo esc_attr($section_title); ?>"
        style="width:100%;">
</p>

<p>
    <label>Section Subtitle:</label><br />
    <textarea name="rto_partners_section_subtitle"
        style="width:100%;"><?php echo esc_textarea($section_subtitle); ?></textarea>
</p>

<?php
}


function rto_faq_section_callback($post)
{
    wp_nonce_field('rto_faq_section_save', 'rto_faq_section_nonce');

    $section_title = get_post_meta($post->ID, '_rto_faq_section_title', true);
    $section_subtitle = get_post_meta($post->ID, '_rto_faq_section_subtitle', true);
    $faq_json = get_post_meta($post->ID, '_rto_faq_list', true);
    $faqs = $faq_json ? json_decode($faq_json, true) : array();
?>

<p>
    <label>Section Title:</label><br />
    <input type="text" name="rto_faq_section_title" value="<?php echo esc_attr($section_title); ?>" style="width:100%;">
</p>

<p>
    <label>Section Subtitle:</label><br />
    <textarea name="rto_faq_section_subtitle"
        style="width:100%;"><?php echo esc_textarea($section_subtitle); ?></textarea>
</p>

<p>
    <label>FAQ:</label><br />
<table id="rto-faq-table" style="width:100%; border-collapse: collapse; border:1px solid #ccc;">
    <thead style="display:table; width:100%; table-layout:fixed;">
        <tr>
            <th style="width:5%;">Sr No</th>
            <th style="width:35%;">Title</th>
            <th style="width:50%;">Description</th>
            <th style="width:10%;">Action</th>
        </tr>
    </thead>
    <tbody id="rto-faq-tbody" style="display:table; width:100%; table-layout:fixed; max-height:500px; overflow-y:auto;">
        <?php
            if ($faqs) {
                $count = 1;
                foreach ($faqs as $key => $faq) {
            ?>
        <tr>
            <td style="width:5%;"><?php echo $count; ?></td>
            <td style="width:35%;"><input type="text" class="faq-title" name="rto_faq_list[<?php echo $key; ?>][title]"
                    value="<?php echo esc_attr($faq['title']); ?>" style="width:100%;"></td>
            <td style="width:50%;"><textarea class="faq-desc" name="rto_faq_list[<?php echo $key; ?>][description]"
                    style="width:100%;"><?php echo esc_textarea($faq['description']); ?></textarea>
            </td>
            <td style="width:10%;"><button class="button rto-remove-btn">Remove</button></td>
        </tr>
        <?php
                    $count++;
                }
            }
            ?>
    </tbody>
</table>
<button class="button" id="rto-add-faq">Add FAQ</button>
<input type="hidden" name="rto_faq_list" id="rto_faq_list" value='<?php echo esc_attr($faq_json); ?>'>
</p>

<script>
jQuery(document).ready(function($) {
    function updateHiddenInput() {
        var faqs = [];
        $('#rto-faq-tbody tr').each(function() {
            var title = $(this).find('.faq-title').val();
            var desc = $(this).find('.faq-desc').val();
            faqs.push({
                title: title,
                description: desc
            });
        });
        $('#rto_faq_list').val(JSON.stringify(faqs));
        // update Sr No
        $('#rto-faq-tbody tr').each(function(i) {
            $(this).find('td:first').text(i + 1);
        });
    }

    $('#rto-add-faq').click(function(e) {
        const length = jQuery('#rto-faq-tbody').children('tr').length;
        e.preventDefault();
        var newRow = '<tr>' +
            '<td style="width:5%;"></td>' +
            '<td style="width:35%;"><input type="text" class="faq-title" name="rto_faq_list[' + length +
            '][title]" style="width:100%;"></td>' +
            '<td style="width:50%;"><textarea class="faq-desc" name="rto_faq_list[' + length +
            '][description]" style="width:100%;"></textarea></td>' +
            '<td style="width:10%;"><button class="button rto-remove-btn">Remove</button></td>' +
            '</tr>';
        $('#rto-faq-tbody').append(newRow);
        updateHiddenInput();
    });

    $(document).on('click', '.rto-remove-btn', function(e) {
        e.preventDefault();
        $(this).closest('tr').remove();
        updateHiddenInput();
    });

    $(document).on('change keyup', '.faq-title, .faq-desc', function() {
        updateHiddenInput();
    });

    updateHiddenInput(); // initial update
});
</script>
<style>
#rto-faq-table thead,
#rto-faq-table tbody {
    display: block;
}

#rto-faq-table tbody {
    max-height: 500px;
    overflow-y: auto;
}

#rto-faq-table th,
#rto-faq-table td {
    border: 1px solid #ccc;
    padding: 5px;
}
</style>
<?php
}






// Save meta box data
add_action('save_post', 'rto_save_meta_boxes');
function rto_save_meta_boxes($post_id)
{
    if (!isset($_POST['rto_banner_section_nonce']) || !wp_verify_nonce($_POST['rto_banner_section_nonce'], 'rto_banner_section_save')) return;

    // Save banner section
    if (isset($_POST['rto_banner_page_title'])) update_post_meta($post_id, '_rto_banner_page_title', sanitize_text_field($_POST['rto_banner_page_title']));
    if (isset($_POST['rto_banner_page_subtitle'])) update_post_meta($post_id, '_rto_banner_page_subtitle', sanitize_text_field($_POST['rto_banner_page_subtitle']));
    if (isset($_POST['rto_banner_description'])) update_post_meta($post_id, '_rto_banner_description', sanitize_textarea_field($_POST['rto_banner_description']));
    if (isset($_POST['rto_banner_bg_image'])) update_post_meta($post_id, '_rto_banner_bg_image', esc_url_raw($_POST['rto_banner_bg_image']));
    if (isset($_POST['rto_banner_images'])) update_post_meta($post_id, '_rto_banner_images', esc_url_raw($_POST['rto_banner_images']));
    if (isset($_POST['rto_banner_phone'])) update_post_meta($post_id, '_rto_banner_phone', sanitize_text_field($_POST['rto_banner_phone']));

    // Save Calculate Section
    if (isset($_POST['rto_calculate_section_title'])) {
        update_post_meta($post_id, '_rto_calculate_section_title', sanitize_text_field($_POST['rto_calculate_section_title']));
    }

    if (isset($_POST['rto_calculate_section_subtitle'])) {
        update_post_meta($post_id, '_rto_calculate_section_subtitle', sanitize_textarea_field($_POST['rto_calculate_section_subtitle']));
    }

    if (isset($_POST['rto_calculate_cost_image'])) {
        update_post_meta($post_id, '_rto_calculate_cost_image', esc_url_raw($_POST['rto_calculate_cost_image']));
    }

    // Save Metal Building Section
    if (isset($_POST['rto_metal_building_title'])) {
        update_post_meta($post_id, '_rto_metal_building_title', sanitize_text_field($_POST['rto_metal_building_title']));
    }

    if (isset($_POST['rto_metal_building_subtitle'])) {
        update_post_meta($post_id, '_rto_metal_building_subtitle', sanitize_textarea_field($_POST['rto_metal_building_subtitle']));
    }

    if (isset($_POST['rto_metal_building_price_limit'])) {
        update_post_meta($post_id, '_rto_metal_building_price_limit', floatval($_POST['rto_metal_building_price_limit']));
    }

    // Save About RTO Section
    if (isset($_POST['rto_about_section_title'])) {
        update_post_meta($post_id, '_rto_about_section_title', sanitize_text_field($_POST['rto_about_section_title']));
    }

    if (isset($_POST['rto_about_section_description'])) {
        update_post_meta($post_id, '_rto_about_section_description', wp_kses_post($_POST['rto_about_section_description']));
    }

    // Save Benefits Section
    if (isset($_POST['rto_benefits_list'])) {
        $benefits_data = wp_unslash($_POST['rto_benefits_list']);
        update_post_meta($post_id, '_rto_benefits_list', $benefits_data);
    }

    if (isset($_POST['rto_benefits_section_title'])) {
        update_post_meta($post_id, '_rto_benefits_section_title', sanitize_text_field($_POST['rto_benefits_section_title']));
    }

    if (isset($_POST['rto_benefits_section_subtitle'])) {
        update_post_meta($post_id, '_rto_benefits_section_subtitle', sanitize_textarea_field($_POST['rto_benefits_section_subtitle']));
    }


    // Save Credit Score Section
    if (isset($_POST['rto_credit_section_title'])) {
        update_post_meta($post_id, '_rto_credit_section_title', sanitize_text_field($_POST['rto_credit_section_title']));
    }

    if (isset($_POST['rto_credit_section_subtitle'])) {
        update_post_meta($post_id, '_rto_credit_section_subtitle', sanitize_textarea_field($_POST['rto_credit_section_subtitle']));
    }

    if (isset($_POST['rto_credit_phone'])) {
        update_post_meta($post_id, '_rto_credit_phone', sanitize_text_field($_POST['rto_credit_phone']));
    }

    if (isset($_POST['rto_credit_financing_link'])) {
        update_post_meta($post_id, '_rto_credit_financing_link', esc_url_raw($_POST['rto_credit_financing_link']));
    }

    if (isset($_POST['rto_credit_bg_image'])) {
        update_post_meta($post_id, '_rto_credit_bg_image', esc_url_raw($_POST['rto_credit_bg_image']));
    }

    if (isset($_POST['rto_credit_mobile_image'])) {
        update_post_meta($post_id, '_rto_credit_mobile_image', esc_url_raw($_POST['rto_credit_mobile_image']));
    }

    // Save Process Section
    if (isset($_POST['rto_process_section_title'])) {
        update_post_meta($post_id, '_rto_process_section_title', sanitize_text_field($_POST['rto_process_section_title']));
    }

    if (isset($_POST['rto_process_section_subtitle'])) {
        update_post_meta($post_id, '_rto_process_section_subtitle', sanitize_textarea_field($_POST['rto_process_section_subtitle']));
    }

    // Save Prices Section
    if (isset($_POST['rto_prices_section_title'])) {
        update_post_meta($post_id, '_rto_prices_section_title', sanitize_text_field($_POST['rto_prices_section_title']));
    }

    if (isset($_POST['rto_prices_section_description'])) {
        update_post_meta($post_id, '_rto_prices_section_description', wp_kses_post($_POST['rto_prices_section_description']));
    }

    // Save Rent To Own Vs. Financing Options Section
    if (isset($_POST['rto_vs_financing_section_title'])) {
        update_post_meta($post_id, '_rto_vs_financing_section_title', sanitize_text_field($_POST['rto_vs_financing_section_title']));
    }

    if (isset($_POST['rto_vs_financing_section_description'])) {
        update_post_meta($post_id, '_rto_vs_financing_section_description', wp_kses_post($_POST['rto_vs_financing_section_description']));
    }
    // Save Partners Section
    if (isset($_POST['rto_partners_section_title'])) {
        update_post_meta($post_id, '_rto_partners_section_title', sanitize_text_field($_POST['rto_partners_section_title']));
    }

    if (isset($_POST['rto_partners_section_subtitle'])) {
        update_post_meta($post_id, '_rto_partners_section_subtitle', sanitize_textarea_field($_POST['rto_partners_section_subtitle']));
    }
    // Save FAQ Section
    if (isset($_POST['rto_faq_list'])) {
        $faq_data = wp_unslash($_POST['rto_faq_list']);
        update_post_meta($post_id, '_rto_faq_list', $faq_data);
    }

    if (isset($_POST['rto_faq_section_title'])) {
        update_post_meta($post_id, '_rto_faq_section_title', sanitize_text_field($_POST['rto_faq_section_title']));
    }

    if (isset($_POST['rto_faq_section_subtitle'])) {
        update_post_meta($post_id, '_rto_faq_section_subtitle', sanitize_textarea_field($_POST['rto_faq_section_subtitle']));
    }
}