<?php
add_action('add_meta_boxes', 'vmg_city_city_meta_boxes');
function vmg_city_city_meta_boxes()
{
    global $post;
    if (!$post) return;

    $template = get_page_template_slug($post->ID);
    if (in_array($template, ['city-state-pages.php'])) {
        add_meta_box('city_state_section', 'Parent State for this city', 'vmg_city_state_section_callback', 'page', 'normal', 'default');
    }

    // Only show for these two templates
    if (in_array($template, ['state-pages.php', 'city-state-pages.php'])) {

        add_meta_box('city_banner_section', 'City Section (Banner)', 'vmg_city_banner_section_callback', 'page', 'normal', 'default');
        add_meta_box('city_top_building_section', 'City Section (Top Building)', 'vmg_city_top_building_section_callback', 'page', 'normal', 'default');
        add_meta_box('city_key_industries_section', 'City Section (Key Industries)', 'vmg_city_key_industries_section_callback', 'page', 'normal', 'default');
        add_meta_box('city_shop_building_section', 'City Section (Shop Customized Building)', 'vmg_city_shop_building_section_callback', 'page', 'normal', 'default');
        add_meta_box('city_rto_finance_section', 'City Section (RTO and Finance)', 'vmg_city_rto_finance_section_callback', 'page', 'normal', 'default');
    }
}

function vmg_city_state_section_callback($post)
{
    $state_id = get_post_meta($post->ID, '_parent_state_id', true);
?>
<p><label>Select state for this city:</label><br>
    <select type="text" name="_parent_state_id" style="width:100%;">
        <option value="">--Select State</option>
        <?php
            $query1 = new WP_Query([
                'post_type'      => 'page',
                'post_status'    => 'publish',
                'posts_per_page' => -1,
                'meta_key'       => '_wp_page_template',
                'meta_value'     => 'state-pages.php',
                'order'          => 'ASC',
                'orderby'        => 'title',
            ]);
            // print_r($query1);
            if ($query1->have_posts()) {
                while ($query1->have_posts()) {
                    $query1->the_post();
                    $selected = !empty($state_id) && $state_id == get_the_ID() ? 'selected="selected"' : '';
                    echo '<option value="' . get_the_ID() . '" ' . $selected . '>' . get_the_title() . '</option>';
                }
                wp_reset_postdata();
            }
            ?>


    </select>

</p>
<?php
}
/* ------------------ Section (Banner) ------------------ */
function vmg_city_banner_section_callback($post)
{
    $title = get_post_meta($post->ID, '_city_banner_title', true);
    $desc  = get_post_meta($post->ID, '_city_banner_description', true);
    $image = get_post_meta($post->ID, '_city_banner_image', true);
    $image = !empty($image) ? $image : site_url() . '/wp-content/uploads/2025/10/Section-Cover.webp';
?>
<p><label>Title:</label><br>
    <input type="text" name="_city_banner_title" value="<?= esc_attr($title); ?>" style="width:100%;">
</p>
<p><label>Description:</label><br>
    <?php wp_editor($desc, '_city_banner_description', [
            'textarea_name' => '_city_banner_description',
            'media_buttons' => false,
            'textarea_rows' => 4,
        ]); ?>
</p>
<p>
    <label><strong>Banner Image:</strong></label><br>
    <input type="text" name="_city_banner_image" id="_city_banner_image" value="<?= esc_attr($image); ?>"
        style="width:80%;">
    <button type="button" class="button" id="upload_banner_image_button">Upload</button>
    <button type="button" class="button" id="remove_banner_image_button">Remove</button>
</p>

<?php if ($image): ?>
<p><img id="banner_image_preview" src="<?= esc_url($image); ?>" style="max-width:300px; height:auto;"></p>
<?php else: ?>
<p><img id="banner_image_preview" src="" style="display:none; max-width:300px; height:auto;"></p>
<?php endif; ?>

<script>
jQuery(document).ready(function($) {
    let frame;

    $('#upload_banner_image_button').on('click', function(e) {
        e.preventDefault();

        // If media frame already exists, reopen it
        if (frame) {
            frame.open();
            return;
        }

        // Create new media frame
        frame = wp.media({
            title: 'Select Banner Image',
            button: {
                text: 'Use This Image'
            },
            multiple: false
        });

        // When an image is selected
        frame.on('select', function() {
            const attachment = frame.state().get('selection').first().toJSON();
            $('#_city_banner_image').val(attachment.url);
            $('#banner_image_preview').attr('src', attachment.url).show();
        });

        // Open the media frame
        frame.open();
    });

    // Remove image
    $('#remove_banner_image_button').on('click', function() {
        $('#_city_banner_image').val('');
        $('#banner_image_preview').hide().attr('src', '');
    });
});
</script>
<?php
}

/* ------------------ Section (Top Building) ------------------ */
function vmg_city_top_building_section_callback($post)
{
    $title = get_post_meta($post->ID, '_city_top_building_title', true);
    $desc  = get_post_meta($post->ID, '_city_top_building_description', true);
?>
<p><label>Title:</label><br>
    <input type="text" name="_city_top_building_title" value="<?= esc_attr($title); ?>" style="width:100%;">
</p>
<p><label>Description:</label><br>
    <?php wp_editor($desc, '_city_top_building_description', [
            'textarea_name' => '_city_top_building_description',
            'media_buttons' => false,
            'textarea_rows' => 4,
        ]); ?>
</p>
<?php
}

/* ------------------ Section (Key Industries) ------------------ */
/* ------------------ Section (Key Industries) ------------------ */
function vmg_city_key_industries_section_callback($post)
{
    $title = get_post_meta($post->ID, '_city_key_industries_title', true);
    $desc  = get_post_meta($post->ID, '_city_key_industries_description', true);
    $industries = get_post_meta($post->ID, '_city_key_industries_repeater', true);

    if (empty($industries)) {

        $industries = array(
            array(
                "title" => "",
                "description" => "",
                "image" => site_url() . "/wp-content/uploads/2025/10/Agricultural-Enterprises.webp"
            ),
            array(
                "title" => "",
                "description" => "",
                "image" => site_url() . "/wp-content/uploads/2025/10/Manufacturing-Facilities.webp"
            ),
            array(
                "title" => "",
                "description" => "",
                "image" => site_url() . "/wp-content/uploads/2025/10/Educational-Institutions.webp"
            ),
            array(
                "title" => "",
                "description" => "",
                "image" => site_url() . "/wp-content/uploads/2025/10/Workshops-Garages.webp"
            ),
            array(
                "title" => "",
                "description" => "",
                "image" => site_url() . "/wp-content/uploads/2025/10/Cold-Storage-Warehouses.webp"
            ),
            array(
                "title" => "",
                "description" => "",
                "image" => site_url() . "/wp-content/uploads/2025/10/Aviation-Hangars.webp"
            )
        );
    }
?>
<p><label>Title:</label><br>
    <input type="text" name="_city_key_industries_title" value="<?= esc_attr($title); ?>" style="width:100%;">
</p>
<p><label>Description:</label><br>
    <?php wp_editor($desc, '_city_key_industries_description', [
            'textarea_name' => '_city_key_industries_description',
            'media_buttons' => false,
            'textarea_rows' => 4,
        ]); ?>
</p>

<h4>Industries</h4>
<table id="cindustries-table" style="width:100%;border-collapse:collapse;" border="1">
    <thead>
        <tr>
            <th style="width:5%;">Sr No</th>
            <th style="width:20%;">Title</th>
            <th style="width:35%;">Description</th>
            <th style="width:25%;">Image</th>
            <th style="width:15%;">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php
            $i = 1;
            if (!empty($industries) && is_array($industries)) {
                foreach ($industries as $row) { ?>
        <tr>
            <td><?= $i; ?></td>
            <td><input type="text" name="_city_key_industries_repeater[<?= $i; ?>][title]"
                    value="<?= esc_attr($row['title']); ?>" style="width:100%;"></td>
            <td><textarea name="_city_key_industries_repeater[<?= $i; ?>][description]"
                    style="width:100%;height:60px;"><?= esc_textarea($row['description']); ?></textarea></td>
            <td>
                <input type="text" name="_city_key_industries_repeater[<?= $i; ?>][image]"
                    value="<?= esc_attr($row['image']); ?>" class="industry-image-url" style="width:80%;">
                <button type="button" class="button cupload-industry-image">Upload</button>
            </td>
            <td><button type="button" class="button cremove-industry-row">Remove</button></td>
        </tr>
        <?php $i++;
                }
            } ?>
    </tbody>
</table>
<p><button type="button" class="button" id="add-cindustry-row">Add Row</button></p>

<script>
jQuery(document).ready(function($) {
    // Add new row
    $('#add-cindustry-row').on('click', function() {
        var table = $('#cindustries-table tbody');
        var count = table.find('tr').length + 1;
        var newRow = `
                    <tr>
                        <td>${count}</td>
                        <td><input type="text" name="_city_key_industries_repeater[${count}][title]" style="width:100%;"></td>
                        <td><textarea name="_city_key_industries_repeater[${count}][description]" style="width:100%;height:60px;"></textarea></td>
                        <td>
                            <input type="text" name="_city_key_industries_repeater[${count}][image]" class="industry-image-url" style="width:80%;">
                            <button type="button" class="button cupload-industry-image">Upload</button>
                        </td>
                        <td><button type="button" class="button cremove-industry-row">Remove</button></td>
                    </tr>`;
        table.append(newRow);
    });

    // Upload Image
    $(document).on('click', '.cupload-industry-image', function(e) {
        e.preventDefault();
        var input = $(this).prev('.industry-image-url');
        var frame = wp.media({
            title: 'Select Image',
            multiple: false
        }).open().on('select', function() {
            var attachment = frame.state().get('selection').first().toJSON();
            input.val(attachment.url);
        });
    });

    // Remove row
    $(document).on('click', '.cremove-industry-row', function() {
        $(this).closest('tr').remove();

        // Reorder Sr No
        $('#cindustries-table tbody tr').each(function(index) {
            $(this).find('td:first').text(index + 1);
        });
    });
});
</script>
<?php
}


/* ------------------ Section (Shop Customized Building) ------------------ */
function vmg_city_shop_building_section_callback($post)
{
    $title = get_post_meta($post->ID, '_city_shop_building_title', true);
    $desc  = get_post_meta($post->ID, '_city_shop_building_description', true);
    $delivery_time  = get_post_meta($post->ID, '_city_shop_building_delivery_time', true);
    $repeater = get_post_meta($post->ID, '_city_shop_building_repeater', true);

    if (empty($repeater)) {
        $repeater = array(
            array(
                "title" => "Doors & Windows",
                "description" => "Enhance convenience and airflow with a variety of door and window options. Choose from roll-up doors, walk-in doors, and framed windows to improve accessibility, ventilation, and natural lighting.",
                "image" => site_url() . "/wp-content/uploads/2025/10/Door-And-Window.webp"
            ),
            array(
                "title" => "Steel Framing",
                "description" => "Built with premium steel, our framing provides unmatched strength, weather resistance, and longevity—ensuring your structure remains sturdy and low-maintenance for years.",
                "image" => site_url() . "/wp-content/uploads/2025/10/Steel-Framing.webp"
            ),
            array(
                "title" => "Roof Styles",
                "description" => "Pick from three dependable roof designs—Regular, Boxed-Eave, and Vertical—each crafted for specific weather conditions and visual preferences. Whether you want budget-friendly or maximum durability, we have the right fit.",
                "image" => site_url() . "/wp-content/uploads/2025/10/Roof-Styles.webp"
            ),
            array(
                "title" => "Custom Sizes",
                "description" => "Get the exact size your project requires. From compact storage units to large commercial spaces, our metal buildings are designed to suit your needs and property dimensions.",
                "image" => site_url() . "/wp-content/uploads/2025/10/Size.webp"
            ),
            array(
                "title" => "Roof Paneling",
                "description" => "Upgrade protection and performance with high-quality roof panels that add structural integrity and long-term resilience against Texas’s diverse weather conditions.",
                "image" => site_url() . "/wp-content/uploads/2025/10/Roof-Paneling.webp"
            ),
            array(
                "title" => "Building Certification",
                "description" => "Ensure compliance and safety with certified metal buildings engineered to meet local codes for wind, snow, and seismic loads—perfect for areas with strict building standards.",
                "image" => site_url() . "/wp-content/uploads/2025/10/Building-Certification.webp"
            ),
            array(
                "title" => "Two-Tone Color Options",
                "description" => "Boost curb appeal with stylish two-tone finishes. Choose contrasting colors for the roof, trim, and walls to create a striking, custom look.",
                "image" => site_url() . "/wp-content/uploads/2025/10/Two-Tone-Color-Options.webp"
            ),
            array(
                "title" => "Color Choices",
                "description" => "Express your personality with a wide palette of colors for the roof, walls, and trim. Match your surroundings or make a bold statement—the choice is yours!",
                "image" => site_url() . "/wp-content/uploads/2025/10/Colors.webp"
            )
        );
    }
?>
<p><label>Title:</label><br>
    <input type="text" name="_city_shop_building_title" value="<?= esc_attr($title); ?>" style="width:100%;">
</p>
<p><label>Description:</label><br>
    <?php wp_editor($desc, '_city_shop_building_description', [
            'textarea_name' => '_city_shop_building_description',
            'media_buttons' => false,
            'textarea_rows' => 4,
        ]); ?>
</p>

<h4>Customization Options:</h4>
<table id="ccustomization-table" style="width:100%;border-collapse:collapse;" border="1">
    <thead>
        <tr>
            <th>Sr No</th>
            <th>Title</th>
            <th>Description</th>
            <th>Image</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php
            $i = 1;
            if (!empty($repeater) && is_array($repeater)) {
                foreach ($repeater as $row) { ?>
        <tr>
            <td><?= $i; ?></td>
            <td><input type="text" name="_city_shop_building_repeater[<?= $i; ?>][title]"
                    value="<?= esc_attr($row['title']); ?>" style="width:100%;"></td>
            <td><textarea name="_city_shop_building_repeater[<?= $i; ?>][description]"
                    style="width:100%;"><?= esc_textarea($row['description']); ?></textarea></td>
            <td>
                <input type="text" name="_city_shop_building_repeater[<?= $i; ?>][image]"
                    value="<?= esc_attr($row['image']); ?>" style="width:100%;" class="customization-image-url">
                <button type="button" class="button cupload-customization-image">Upload</button>
            </td>
            <td><button type="button" class="button cremove-row">Remove</button></td>
        </tr>
        <?php $i++;
                }
            } ?>
    </tbody>
</table>
<p><button type="button" class="button" id="cadd-customization-row">Add Row</button></p>


<!-- <p><label>Delivery Time Details:</label><br>
    <?php wp_editor($delivery_time, '_city_shop_building_delivery_time', [
            'textarea_name' => '_city_shop_building_delivery_time',
            'media_buttons' => false,
            'textarea_rows' => 4,
        ]); ?>
</p> -->
<script>
jQuery(document).ready(function($) {
    // Add new row
    $('#cadd-customization-row').on('click', function() {
        var table = $('#ccustomization-table tbody');
        var count = table.find('tr').length + 1;
        var row = `
                    <tr>
                        <td>${count}</td>
                        <td><input type="text" name="_city_shop_building_repeater[${count}][title]" style="width:100%;"></td>
                        <td><textarea name="_city_shop_building_repeater[${count}][description]" style="width:100%;"></textarea></td>
                        <td>
                            <input type="text" name="_city_shop_building_repeater[${count}][image]" style="width:100%;" class="customization-image-url">
                            <button type="button" class="button cupload-customization-image">Upload</button>
                        </td>
                        <td><button type="button" class="button cremove-row">Remove</button></td>
                    </tr>`;
        table.append(row);
    });

    // Upload image
    $(document).on('click', '.cupload-customization-image', function(e) {
        e.preventDefault();
        var input = $(this).prev('input');
        var frame = wp.media({
            title: 'Select Image',
            multiple: false
        }).open().on('select', function() {
            var attachment = frame.state().get('selection').first().toJSON();
            input.val(attachment.url);
        });
    });

    // Remove row
    $(document).on('click', '.cremove-row', function() {
        $(this).closest('tr').remove();
    });
});
</script>
<?php
}

/* ------------------ Section (RTO and Finance) ------------------ */
function vmg_city_rto_finance_section_callback($post)
{
    $title = get_post_meta($post->ID, '_city_rto_finance_title', true);
    $desc  = get_post_meta($post->ID, '_city_rto_finance_description', true);
?>
<p><label>Title:</label><br>
    <input type="text" name="_city_rto_finance_title" value="<?= esc_attr($title); ?>" style="width:100%;">
</p>
<p><label>Description:</label><br>
    <textarea name="_city_rto_finance_description" style="width:100%;" rows="4"><?= esc_textarea($desc); ?></textarea>
</p>
<?php
}

/* ------------------ Section (RTO) ------------------ */
function vmg_city_rto_section_callback($post)
{
    $title = get_post_meta($post->ID, '_city_rto_title', true);
    $img   = get_post_meta($post->ID, '_city_rto_image', true);
    $desc  = get_post_meta($post->ID, '_city_rto_description', true);
    $btn_text = get_post_meta($post->ID, '_city_rto_button_text', true);
    $btn_link = get_post_meta($post->ID, '_city_rto_button_link', true);
?>
<p><label>Title:</label><br>
    <input type="text" name="_city_rto_title" value="<?= esc_attr($title); ?>" style="width:100%;">
</p>
<p><label>Image:</label><br>
    <input type="text" name="_city_rto_image" id="city_rto_image" value="<?= esc_attr($img); ?>" style="width:80%;">
    <button class="button" id="upload_rto_image">Upload</button><br>
    <?php if ($img) : ?>
    <img id="city_rto_preview" src="<?= esc_url($img); ?>" style="max-width:200px;margin-top:10px;">
    <?php endif; ?>
</p>
<script>
jQuery(document).ready(function($) {
    $('#upload_rto_image').on('click', function(e) {
        e.preventDefault();
        var frame = wp.media({
            title: 'Select Image',
            multiple: false
        }).open().on('select', function() {
            var attachment = frame.state().get('selection').first().toJSON();
            $('#city_rto_image').val(attachment.url);
            $('#city_rto_preview').attr('src', attachment.url).show();
        });
    });
});
</script>
<p><label>Description:</label><br>
    <?php wp_editor($desc, '_city_rto_description', [
            'textarea_name' => '_city_rto_description',
            'media_buttons' => false,
            'textarea_rows' => 4,
        ]); ?>
</p>
<p><label>Button Text:</label><br>
    <input type="text" name="_city_rto_button_text" value="<?= esc_attr($btn_text); ?>" style="width:100%;">
</p>
<p><label>Button Link:</label><br>
    <input type="text" name="_city_rto_button_link" value="<?= esc_attr($btn_link); ?>" style="width:100%;">
</p>
<?php
}

/* ------------------ Section (Finance) ------------------ */
function vmg_city_finance_section_callback($post)
{
    $title = get_post_meta($post->ID, '_city_finance_title', true);
    $img   = get_post_meta($post->ID, '_city_finance_image', true);
    $desc  = get_post_meta($post->ID, '_city_finance_description', true);
    $btn_text = get_post_meta($post->ID, '_city_finance_button_text', true);
    $btn_link = get_post_meta($post->ID, '_city_finance_button_link', true);
?>
<p><label>Title:</label><br>
    <input type="text" name="_city_finance_title" value="<?= esc_attr($title); ?>" style="width:100%;">
</p>
<p><label>Image:</label><br>
    <input type="text" name="_city_finance_image" id="city_finance_image" value="<?= esc_attr($img); ?>"
        style="width:80%;">
    <button class="button" id="upload_finance_image">Upload</button><br>
    <?php if ($img) : ?>
    <img id="city_finance_preview" src="<?= esc_url($img); ?>" style="max-width:200px;margin-top:10px;">
    <?php endif; ?>
</p>
<script>
jQuery(document).ready(function($) {
    $('#upload_finance_image').on('click', function(e) {
        e.preventDefault();
        var frame = wp.media({
            title: 'Select Image',
            multiple: false
        }).open().on('select', function() {
            var attachment = frame.state().get('selection').first().toJSON();
            $('#city_finance_image').val(attachment.url);
            $('#city_finance_preview').attr('src', attachment.url).show();
        });
    });
});
</script>
<p><label>Description:</label><br>
    <?php wp_editor($desc, '_city_finance_description', [
            'textarea_name' => '_city_finance_description',
            'media_buttons' => false,
            'textarea_rows' => 4,
        ]); ?>
</p>
<p><label>Button Text:</label><br>
    <input type="text" name="_city_finance_button_text" value="<?= esc_attr($btn_text); ?>" style="width:100%;">
</p>
<p><label>Button Link:</label><br>
    <input type="text" name="_city_finance_button_link" value="<?= esc_attr($btn_link); ?>" style="width:100%;">
</p>
<?php
}

/* ------------------ Save All Meta ------------------ */
add_action('save_post', 'vmg_city_city_save_meta');
function vmg_city_city_save_meta($post_id)
{
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    $_parent_state_id = isset($_POST['_parent_state_id']) ? $_POST['_parent_state_id'] : '';
    update_post_meta($post_id, '_parent_state_id', $_parent_state_id);

    foreach ($_POST as $key => $value) {
        if ($key !== '_parent_state_id' && strpos($key, '_city_') === 0) {
            update_post_meta($post_id, $key, $value);
        }
    }
}