<?php
add_action('init', function () {
    // Allow requests from any origin
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization");

    // Handle preflight requests
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        exit(0);
    }
});

// Enable SVG upload
function allow_svg_uploads($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'allow_svg_uploads');
// Disable Gutenberg for Widgets
add_filter('use_widgets_block_editor', '__return_false');

// Disable Gutenberg for 'manufacturer' post type
add_filter('use_block_editor_for_post_type', function ($use_block_editor, $post_type) {
    if ($post_type === 'manufacturer') {
        return false; // Disable block editor
    }
    return $use_block_editor;
}, 9999, 2);

add_filter('rest_api_init', function () {
    remove_filter('rest_pre_serve_request', 'rest_send_cors_headers');
    add_filter('rest_pre_serve_request', function ($value) {
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
        return $value;
    });
}, 15);


function disable_wp_frontend()
{
    // Allow REST API and admin area
    if (is_admin() || defined('REST_REQUEST')) {
        return;
    }

    // Allow login/logout
    if (preg_match('/wp-login\.php|wp-register\.php/', $_SERVER['PHP_SELF'])) {
        return;
    }

    // Redirect all other frontend requests to your React app
    wp_redirect('https://react-frontend-domain.com');
    exit;
}
// add_action( 'template_redirect', 'disable_wp_frontend' );


add_action('init', function () {
    global $wp_taxonomies;

    if (isset($wp_taxonomies['product-taxonomy'])) {
        $wp_taxonomies['product-taxonomy']->show_in_nav_menus = true;
    }
});



// Add custom field (image upload) to menu items
add_action('wp_nav_menu_item_custom_fields', function ($item_id, $item) {
    $image_id = get_post_meta($item_id, '_menu_item_image', true);
    $image_url = $image_id ? wp_get_attachment_url($image_id) : '';
    $show_on_hover = get_post_meta($item_id, '_menu_item_hover_image', true);

?>
<p class="field-custom description description-wide">
    <label for="edit-menu-item-image-<?php echo esc_attr($item_id); ?>">
        <?php _e('Menu Item Image', 'textdomain'); ?><br>

        <input type="hidden" class="menu-item-image-id" name="menu-item-image[<?php echo esc_attr($item_id); ?>]"
            id="edit-menu-item-image-<?php echo esc_attr($item_id); ?>" value="<?php echo esc_attr($image_id); ?>">

        <img class="menu-item-image-preview" src="<?php echo esc_url($image_url); ?>"
            style="max-height:100px; display:<?php echo $image_url ? 'block' : 'none'; ?>; margin-top:10px;">

        <br>
        <button type="button" class="button upload-menu-item-image">
            <?php echo $image_url ? 'Change Image' : 'Upload Image'; ?>
        </button>
        <button type="button" class="button remove-menu-item-image"
            style="display:<?php echo $image_url ? 'inline-block' : 'none'; ?>;">
            Remove
        </button>
    </label>
</p>
<p class="field-custom description description-wide">
    <label for="edit-menu-item-hover-<?php echo esc_attr($item_id); ?>">
        <input type="checkbox" name="menu-item-hover-image[<?php echo esc_attr($item_id); ?>]"
            id="edit-menu-item-hover-<?php echo esc_attr($item_id); ?>" value="1"
            <?php checked($show_on_hover, 1); ?> />
        <?php _e('Show image on hover', 'textdomain'); ?>
    </label>
</p>
<?php
}, 10, 2);


add_action('wp_update_nav_menu_item', function ($menu_id, $menu_item_db_id) {
    if (isset($_POST['menu-item-image'][$menu_item_db_id])) {
        $image_id = intval($_POST['menu-item-image'][$menu_item_db_id]);
        update_post_meta($menu_item_db_id, '_menu_item_image', $image_id);
    } else {
        delete_post_meta($menu_item_db_id, '_menu_item_image');
    }
    if (isset($_POST['menu-item-hover-image'][$menu_item_db_id])) {
        update_post_meta($menu_item_db_id, '_menu_item_hover_image', 1);
    } else {
        delete_post_meta($menu_item_db_id, '_menu_item_hover_image');
    }
}, 10, 2);


add_action('admin_enqueue_scripts', function ($hook) {
    if ('nav-menus.php' !== $hook) return;

    wp_enqueue_media();
    wp_add_inline_script('jquery-core', "
        jQuery(document).ready(function($) {
            var frame;
            $(document).on('click', '.upload-menu-item-image', function(e) {
                e.preventDefault();
                var button = $(this);
                var container = button.closest('label');
                var input = container.find('.menu-item-image-id');
                var preview = container.find('.menu-item-image-preview');
                var removeBtn = container.find('.remove-menu-item-image');

                if (frame) frame.close();
                frame = wp.media({
                    title: 'Select or Upload Image',
                    button: { text: 'Use this image' },
                    multiple: false
                });
                frame.on('select', function() {
                    var attachment = frame.state().get('selection').first().toJSON();
                    input.val(attachment.id);
                    preview.attr('src', attachment.url).show();
                    button.text('Change Image');
                    removeBtn.show();
                });
                frame.open();
            });

            $(document).on('click', '.remove-menu-item-image', function(e) {
                e.preventDefault();
                var container = $(this).closest('label');
                container.find('.menu-item-image-id').val('');
                container.find('.menu-item-image-preview').hide();
                container.find('.upload-menu-item-image').text('Upload Image');
                $(this).hide();
            });
        });
    ");
});


add_filter('walker_nav_menu_start_el', function ($item_output, $item, $depth, $args) {
    $image_id = get_post_meta($item->ID, '_menu_item_image', true);
    if ($image_id) {
        $img = wp_get_attachment_image($image_id, 'thumbnail', false, ['class' => 'menu-item-icon']);
        $item_output = $img . $item_output;
    }
    $show_on_hover = get_post_meta($item->ID, '_menu_item_hover_image', true);
    if ($show_on_hover) {
        // Add a CSS class or wrap with span to show image on hover
        $item_output = '<span class="hover-image-enabled">' . $item_output . '</span>';
    }
    return $item_output;
}, 10, 4);




// Add custom column to blog for featured blog

// Add "Featured" column
// add_filter('manage_blog_posts_columns', function ($columns) {
//     unset($columns['date']);
//     unset($columns['author']);
//     $columns['featured'] = 'Featured';
//     $columns['date'] = 'Date';
//     $columns['author'] = 'Author';
//     return $columns;
// });


// // Show star icon
// add_action('manage_blog_posts_custom_column', function ($column, $post_id) {
//     if ($column === 'featured') {
//         echo $featured = get_post_meta($post_id, '_is_featured', true);
//         $star_class = $featured ? 'dashicons-star-filled' : 'dashicons-star-empty';
//         echo '<span class="featured-star dashicons ' . esc_attr($star_class) . '"
//                   data-postid="' . esc_attr($post_id) . '"
//                   style="cursor:pointer;"></span>';
//     }
// }, 10, 2);

// add_action('admin_enqueue_scripts', function ($hook) {
//     wp_enqueue_script('featured-star-js', get_template_directory_uri() . '/inc/endpoints-customizations/admin/assets/js/admin-featured-star.js', array('jquery'), null, true);
//     wp_localize_script('featured-star-js', 'featuredStar', array(
//         'ajax_url' => admin_url('admin-ajax.php'),
//         'nonce'    => wp_create_nonce('toggle_featured_nonce')
//     ));
//     global $post_type;
//     if ('blog' === $post_type) {
//         wp_enqueue_media();
//     }
// });

// // Toggle featured via AJAX
// add_action('wp_ajax_toggle_featured', function () {
//     check_ajax_referer('toggle_featured_nonce', 'nonce');
//     $post_id = intval($_POST['post_id']);
//     $current = get_post_meta($post_id, '_is_featured', true);
//     if ($current) {
//         delete_post_meta($post_id, '_is_featured');
//         wp_send_json_success(array('featured' => false));
//     } else {
//         update_post_meta($post_id, '_is_featured', 1);
//         wp_send_json_success(array('featured' => true));
//     }
// });

// Add "Featured" column for custom post type 'blog'
add_filter('manage_blog_posts_columns', function ($columns) {
    // remove date/author then re-add so Featured shows where you want
    unset($columns['date']);
    unset($columns['author']);
    $columns['featured'] = 'Featured';
    $columns['date'] = 'Date';
    $columns['author'] = 'Author';
    return $columns;
});

// Render the star in the "Featured" column
add_action('manage_blog_posts_custom_column', function ($column, $post_id) {
    if ($column === 'featured') {
        // get_post_meta returns '' if not set; treat '1' as featured
        $featured = get_post_meta($post_id, '_is_featured', true);
        $star_class = $featured ? 'dashicons-star-filled' : 'dashicons-star-empty';
        echo '<span class="featured-star dashicons ' . esc_attr($star_class) . '"
                  data-postid="' . esc_attr($post_id) . '"
                  style="cursor:pointer;" title="Toggle featured"></span>';
    }
}, 10, 2);

// Enqueue admin script only on the blog list screen (edit.php?post_type=blog)
add_action('admin_enqueue_scripts', function ($hook) {
    // Only load on post list screen (edit.php)
    if ($hook !== 'edit.php') {
        return;
    }

    // Make sure we target only our custom post type 'blog'
    if (! ( isset($_GET['post_type']) && $_GET['post_type'] === 'blog' )) {
        return;
    }

    // enqueue script
    wp_enqueue_script(
        'featured-star-js',
        get_template_directory_uri() . '/inc/endpoints-customizations/admin/assets/js/admin-featured-star.js',
        array('jquery'),
        null,
        true
    );

    // localize data (ajax URL and nonce)
    wp_localize_script('featured-star-js', 'featuredStar', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce'    => wp_create_nonce('toggle_featured_nonce')
    ));
});

// AJAX: toggle featured
add_action('wp_ajax_toggle_featured', function () {
    // check nonce
    check_ajax_referer('toggle_featured_nonce', 'nonce');

    // sanitize post_id and capability
    $post_id = isset($_POST['post_id']) ? intval($_POST['post_id']) : 0;
    if ($post_id <= 0) {
        wp_send_json_error(array('message' => 'Invalid post ID'));
    }

    if (!current_user_can('edit_post', $post_id)) {
        wp_send_json_error(array('message' => 'Insufficient permissions'));
    }

    $current = get_post_meta($post_id, '_is_featured', true);

    if ($current) {
        // remove meta
        delete_post_meta($post_id, '_is_featured');
        wp_send_json_success(array('featured' => false));
    } else {
        // set meta to 1
        update_post_meta($post_id, '_is_featured', 1);
        wp_send_json_success(array('featured' => true));
    }
});



// Featured blog image upload for header resource submenu

function blog_custom_image_metabox()
{
    add_meta_box(
        'blog_image_metabox',          // ID
        'Featured Blog header Image',         // Title
        'blog_image_metabox_callback', // Callback
        'blog',                        // Post type
        'side',                        // Context (side, normal, advanced)
        'default'                      // Priority
    );
}
add_action('add_meta_boxes', 'blog_custom_image_metabox');

function blog_image_metabox_callback($post)
{
    wp_nonce_field(basename(__FILE__), 'blog_image_nonce');

    $blog_image_id = get_post_meta($post->ID, '_blog_image_id', true);
    $image_url = $blog_image_id ? wp_get_attachment_url($blog_image_id) : '';

?>
<div>
    <img id="blog-image-preview" src="<?php echo esc_url($image_url); ?>"
        style="max-width:100%; <?php echo $image_url ? '' : 'display:none;'; ?>" />

    <input type="hidden" id="blog-image-id" name="blog_image_id" value="<?php echo esc_attr($blog_image_id); ?>" />

    <p>
        <button type="button" class="button" id="blog-image-upload">Upload Image</button>
        <button type="button" class="button" id="blog-image-remove"
            <?php echo $image_url ? '' : 'style="display:none;"'; ?>>Remove Image</button>
    </p>
</div>

<script>
jQuery(document).ready(function($) {
    var frame;
    $('#blog-image-upload').on('click', function(e) {
        e.preventDefault();

        if (frame) {
            frame.open();
            return;
        }

        frame = wp.media({
            title: 'Select or Upload Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        });

        frame.on('select', function() {
            var attachment = frame.state().get('selection').first().toJSON();
            $('#blog-image-id').val(attachment.id);
            $('#blog-image-preview').attr('src', attachment.url).show();
            $('#blog-image-remove').show();
        });

        frame.open();
    });

    $('#blog-image-remove').on('click', function() {
        $('#blog-image-id').val('');
        $('#blog-image-preview').hide();
        $(this).hide();
    });
});
</script>
<?php
}
function blog_save_image_metabox($post_id)
{
    if (!isset($_POST['blog_image_nonce']) || !wp_verify_nonce($_POST['blog_image_nonce'], basename(__FILE__))) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    if (isset($_POST['blog_image_id'])) {
        update_post_meta($post_id, '_blog_image_id', sanitize_text_field($_POST['blog_image_id']));
    }
}
add_action('save_post_blog', 'blog_save_image_metabox');





// register sidebar
function vmg_widgets_init()
{

    register_sidebar(array(
        'name'          => __('React Footer 1', 'textdomain'),
        'id'            => 'react_footer-1',
        'description'   => __('Widgets in this area will be shown on all posts and pages.', 'textdomain'),
        'before_widget' => '<ul id="%1$s" class="widget %2$s">',
        'after_widget'  => '</ul>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ));
    register_sidebar(array(
        'name'          => __('React Footer 2', 'textdomain'),
        'id'            => 'react_footer-2',
        'description'   => __('Widgets in this area will be shown on all posts and pages.', 'textdomain'),
        'before_widget' => '<ul id="%1$s" class="widget %2$s">',
        'after_widget'  => '</ul>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ));
    register_sidebar(array(
        'name'          => __('React Footer 3', 'textdomain'),
        'id'            => 'react_footer-3',
        'description'   => __('Widgets in this area will be shown on all posts and pages.', 'textdomain'),
        'before_widget' => '<ul id="%1$s" class="widget %2$s">',
        'after_widget'  => '</ul>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ));
    register_sidebar(array(
        'name'          => __('React Footer 4', 'textdomain'),
        'id'            => 'react_footer-4',
        'description'   => __('Widgets in this area will be shown on all posts and pages.', 'textdomain'),
        'before_widget' => '<ul id="%1$s" class="widget %2$s">',
        'after_widget'  => '</ul>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ));
    register_sidebar(array(
        'name'          => __('React Footer 5', 'textdomain'),
        'id'            => 'react_footer-5',
        'description'   => __('Widgets in this area will be shown on all posts and pages.', 'textdomain'),
        'before_widget' => '<ul id="%1$s" class="widget %2$s">',
        'after_widget'  => '</ul>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ));
}
add_action('widgets_init', 'vmg_widgets_init');


// Allow filtering products by SKU in REST API
function filter_products_by_sku($args, $request)
{
    if (isset($request['sku']) && ! empty($request['sku'])) {
        $args['meta_query'] = [
            [
                'key'     => 'sku', // ✅ your meta_key for SKU
                'value'   => sanitize_text_field($request['sku']),
                'compare' => 'LIKE'
            ]
        ];
    }
    return $args;
}
add_filter('rest_product_query', 'filter_products_by_sku', 999, 2);


function vmg_get_all_template_page_counts()
{
    global $wpdb;

    // Fetch all templates assigned to pages
    $results = $wpdb->get_results("
        SELECT meta_value AS template, COUNT(*) AS count
        FROM {$wpdb->postmeta}
        INNER JOIN {$wpdb->posts} ON {$wpdb->posts}.ID = {$wpdb->postmeta}.post_id
        WHERE meta_key = '_wp_page_template'
        AND {$wpdb->posts}.post_type = 'page'
        AND {$wpdb->posts}.post_status = 'publish'
        GROUP BY meta_value
    ");

    $templates = array();

    if ($results) {
        foreach ($results as $row) {
            $templates[$row->template] = (int) $row->count;
        }
    }

    return $templates;
}

function vmg_custom_authenticate($username, $password)
{
    global $wpdb;

    // Get the user row
    $user = $wpdb->get_row($wpdb->prepare(
        "SELECT ID, user_login, user_pass FROM $wpdb->users WHERE user_login = %s",
        $username
    ));

    if ($user && wp_check_password($password, $user->user_pass, $user->ID)) {
        // Authentication success → return WP_User object
        return get_userdata($user->ID);
    }

    // Authentication failed
    return false;
}

function identify_slug_type( $slug ) {
    // 1. Pages and posts (includes CPTs)
    $post_types = array('page', 'blog', 'infographics', 'manufacturer', 'product');
    foreach ( $post_types as $type ) {
        $post = get_page_by_path( $slug, OBJECT, $type );
        if ( $post && $post->post_status == 'publish') {
            return [
                'type' => $type,
                'object' => $post,
            ];
        }
    }

    // 2. Categories
    $cat = get_category_by_slug( $slug );
    if ( $cat ) {
        return [
            'type' => 'category',
            'object' => $cat,
        ];
    }

    // 3. Any taxonomy term
    $taxonomies = get_taxonomies(['public' => true], 'names');
    foreach ( $taxonomies as $tax ) {
        $term = get_term_by( 'slug', $slug, $tax );
        if ( $term ) {
            return [
                'type' => $tax,
                'object' => $term,
            ];
        }
    }

    return false; // Not found
}

// Register Theme Settings menu

/**
 * Create two taxonomies, genres and writers for the post type "book".
 *
 * @see register_post_type() for registering custom post types.
 */
function vmg_create_roof_styles_taxonomies() {
	// Add new taxonomy, make it hierarchical (like categories)
	$labels = array(
		'name'              => _x( 'Roof Styles', 'taxonomy general name', 'textdomain' ),
		'singular_name'     => _x( 'Roof Style', 'taxonomy singular name', 'textdomain' ),
		'search_items'      => __( 'Search Roof Styles', 'textdomain' ),
		'all_items'         => __( 'All Roof Styles', 'textdomain' ),
		'parent_item'       => __( 'Parent Roof Style', 'textdomain' ),
		'parent_item_colon' => __( 'Parent Roof Style:', 'textdomain' ),
		'edit_item'         => __( 'Edit Roof Style', 'textdomain' ),
		'update_item'       => __( 'Update Roof Style', 'textdomain' ),
		'add_new_item'      => __( 'Add New Roof Style', 'textdomain' ),
		'new_item_name'     => __( 'New Roof Style Name', 'textdomain' ),
		'menu_name'         => __( 'Roof Style', 'textdomain' ),
	);

	$args = array(
		'hierarchical'      => true,
		'labels'            => $labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'roof-styles' ),
	);

	register_taxonomy( 'product_roof_style', array( 'product' ), $args );

}
// hook into the init action and call create_book_taxonomies when it fires
add_action( 'init', 'vmg_create_roof_styles_taxonomies', 0 );
add_filter('use_block_editor_for_post_type', function($use_block_editor, $post_type) {
    if ($post_type === 'product') {
        return false; // disable for products
    }
    return $use_block_editor;
}, 10, 2);


add_filter('wpseo_robots', function( $robots ) {
    if ( is_singular('manufacturer') ) {
        return 'noindex, nofollow';
    }
    return $robots;
});


add_action('template_redirect', function() {
    global $post;

    if (!empty($post)) {
        $post_type = get_post_type($post->ID);

        if ($post_type === 'manufacturer') {
            global $wp_query;
            $wp_query->set_404();
            status_header(404);
            nocache_headers();
            include(get_query_template('404'));
            exit;
        }
    }
});

function mytheme_customize_register( $wp_customize ) {

    // 1️⃣ Add a new section for Theme Settings
    $wp_customize->add_section('theme_settings_section', array(
        'title'       => __('Theme Settings', 'mytheme'),
        'priority'    => 30,
        'description' => 'Manage contact and social media details for the site.',
    ));

    // 2️⃣ Create fields
    $fields = [
        'phone_number' => 'Phone Number',
        'email_address' => 'Email Address',
        'address' => 'Address',
        'facebook_url' => 'Facebook URL',
        'twitter_url' => 'Twitter URL',
        'instagram_url' => 'Instagram URL',
        'linkedin_url' => 'LinkedIn URL',
    ];

    foreach ($fields as $id => $label) {
        $wp_customize->add_setting($id, array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
            'transport'         => 'refresh',
        ));

        $wp_customize->add_control($id, array(
            'label'   => __($label, 'mytheme'),
            'section' => 'theme_settings_section',
            'type'    => 'text',
        ));
    }
}
add_action('customize_register', 'mytheme_customize_register');

function vmg_register_blog_category_taxonomy() {

    $labels = array(
        'name'              => 'Categories',
        'singular_name'     => 'Category',
        'search_items'      => 'Search Categories',
        'all_items'         => 'All Categories',
        'edit_item'         => 'Edit Category',
        'update_item'       => 'Update Category',
        'add_new_item'      => 'Add New Category',
        'new_item_name'     => 'New Category Name',
        'menu_name'         => 'Categories',
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'blog_category'),
    );

    register_taxonomy('blog_category', array('blog'), $args);
}
add_action('init', 'vmg_register_blog_category_taxonomy');


function vmg_register_infographics_category_taxonomy() {

    $labels = array(
        'name'              => 'Categories',
        'singular_name'     => 'Category',
        'search_items'      => 'Search Categories',
        'all_items'         => 'All Categories',
        'edit_item'         => 'Edit Category',
        'update_item'       => 'Update Category',
        'add_new_item'      => 'Add New Category',
        'new_item_name'     => 'New Category Name',
        'menu_name'         => 'Categories',
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'infographics_category'),
    );

    register_taxonomy('infographics_category', array('infographics'), $args);
}
add_action('init', 'vmg_register_infographics_category_taxonomy');

//
function get_ip_location_by_address($ipaddress){

    $url = 'https://freegeoip.net/json/' . $ipaddress;

    $data = file_get_contents($url);

    $data = json_decode($data);

    return $data->country_code;
}

function zoho_integration_data_mapping_api($name, $email, $phone, $state, $zipcode, $comment, $form_source, $pageUrl, $ipaddress, $page_name){
    $country = strtolower(get_ip_location_by_address($ipaddress));
    $disallow_country = array("in", "bd", "np", "pk");

    if ($ipaddress == '183.182.86.178' || !in_array($country, $disallow_country)) {

        $data_array = array();
        $data_array['First_Name'] = $name;
        $data_array['Last_Name'] = 'N/A';
        $data_array['Email'] = $email;
        $data_array['Phone'] = $phone;
        if(!empty($state)){
            $data_array['State'] = $state;
        }
        if(!empty($zipcode)){
            $data_array['Zip_Code'] = $zipcode;
        }
        $data_array['Message'] = $comment;

        if (!empty($page_name)) {
            $data_array['Product_Title'] = $page_name;
        }
        if (!empty($pageUrl)) {
            $data_array['Product_Link'] = $pageUrl;
        }
        $data_array['Leads_Owner'] = 'Alberto Ochoa';
        $data_array['Lead_Status'] = 'New Lead';
        $data_array['Lead_Source'] = 'Viking Metal Garages Website';
        $data_array['Website_Source_Form1'] = $form_source;

        $jsondata = array(
                        'data' =>   array( 0 => $data_array ),
                        'triggger' => array('workflow', 'approval', 'blueprint')
                    );

        $fields = json_encode($jsondata);

        // print_r($fields);



        $accessTokenData = array(

        'refresh_token' => '1000.b12728aa55c88af04c9782cdf0f90a79.c81f0967bf8fcb038663a9de8be3c483',

        'client_id' => '1000.6EYL4CQX6UE5JR2IQ7SJP23J278JEH',

        'client_secret' => '63d7823035d27eecb75adc9839ddc8481331d07e7d',

        'grant_type' => 'refresh_token'

        );

        $access_token_url = 'https://accounts.zoho.com/oauth/v2/token';

        $curlPost = curl_init();

        curl_setopt($curlPost, CURLOPT_URL, $access_token_url);

        curl_setopt($curlPost, CURLOPT_POST, 0);

        curl_setopt($curlPost, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($curlPost, CURLOPT_TIMEOUT, 30);

        curl_setopt($curlPost, CURLOPT_SSL_VERIFYPEER, false);

        curl_setopt($curlPost, CURLOPT_SSL_VERIFYHOST, false);

        curl_setopt($curlPost, CURLOPT_POSTFIELDS, $accessTokenData);

        $access_token_result = curl_exec($curlPost);

        $access_token_post = json_decode($access_token_result);

        $access_token = $access_token_post->access_token;

        //------ End Refresh Access Token==================//





        $url = 'https://www.zohoapis.com/crm/v2/Leads';

        $key = 'Zoho-oauthtoken ' . $access_token;

        $header = array("Content-Type: application/json", "Content-Length: " . strlen($fields), "Authorization: " . $key);

        $curl = curl_init();

        curl_setopt($curl, CURLOPT_URL, $url);

        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);

        curl_setopt($curl, CURLOPT_POST, 0);

        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($curl, CURLOPT_TIMEOUT, 30);

        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);

        curl_setopt($curl, CURLOPT_POSTFIELDS, $fields);

        $result = curl_exec($curl);



        $zohotxt = fopen(ABSPATH ."zohojson.txt", "a");

        fwrite($zohotxt, print_r($result, true) . " , VMG node form source".date('d-m-Y')." : " . $form_source . ' , ' . $fields . PHP_EOL);

        fclose($zohotxt);

        curl_close($curl);

        // print_r($result);

        // die;
    }
}