<?php
/* Template Name: Product XML Feed */
header('Content-Type: application/rss+xml; charset=' . get_option('blog_charset'), true);
echo '<?xml version="1.0" encoding="' . get_option('blog_charset') . '"?' . '>';
?>
<rss xmlns:g="http://base.google.com/ns/1.0" version="2.0">
    <channel>
        <title><?php bloginfo_rss('name'); ?></title>
        <link><?php bloginfo_rss('url'); ?></link>
        <description>Viking Metal Garages offers you a wide range of Metal Garages for Sale. You can also Buy Prefab Metal Buildings with unlimited customization. Get a custom free quote for your choice.</description>
        <?php
        // Fetch custom posts or products
        $args = array(
            'post_type' => 'product', 
            'posts_per_page' => -1,
            'post_status' => 'publish'
        );
        $products = new WP_Query($args);
        if ($products->have_posts()) :
            $serial_number = 1; // Initialize serial number
            while ($products->have_posts()) : $products->the_post();
                $product_id = get_the_ID();
                $product_title = get_the_title();
                // Replace special characters with their respective ASCII values
                $product_title = str_replace(
                    array('&#8217;', '&#8242;'), // Special characters to replace
                    array("'", "'"),            // Replacement characters
                    $product_title
                );
                $product_link = get_permalink();
                //$yoast_meta_description = get_post_meta(get_the_ID(), '_yoast_wpseo_metadesc', true);
                $product_description =  get_the_excerpt();
                  // Replace special characters with their respective ASCII values
				  $product_description = str_replace(
                    array('&#8217;', '&#8242;', '&'), 
                    array("'", "'", '&amp;'),            
                    $product_description
                  );
                $product_image = get_the_post_thumbnail_url($product_id, 'full');
                $product_price = get_post_meta($product_id, 'prices', true);
                $product_sku = get_post_meta($product_id, 'sku', true);
                ?>
                <item>
                    <g:id><?php echo  $serial_number; ?></g:id>
                    <g:title><?php echo $product_title; ?></g:title>
                    <g:description><?php echo $product_description; ?></g:description>
                    <g:link><?php echo esc_url($product_link); ?></g:link>
                    <g:image_link><?php echo esc_url($product_image); ?></g:image_link>
                    <g:availability>in stock</g:availability>
                    <g:price><?php echo esc_html($product_price); ?> USD</g:price>
                    <g:brand><?php bloginfo('name'); ?></g:brand>
                    <g:mpn><?php echo esc_html($product_sku); ?></g:mpn>
                    <g:condition>new</g:condition>
                </item>
                <?php
                $serial_number++;
            endwhile;
            wp_reset_postdata();
        endif;
        ?>
    </channel>
</rss>
